/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.prop;

import gaia.entity.Mandragora;
import gaia.entity.prop.AbstractPropEntity;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaSounds;
import gaia.registry.GaiaTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.Nullable;

public class CyanFlower
extends AbstractPropEntity {
    public CyanFlower(EntityType<? extends AgeableMob> type, Level level) {
        super(type, level);
        this.xpReward = 0;
        this.yBodyRotO = 180.0f;
        this.yBodyRot = 180.0f;
    }

    public float getWalkTargetValue(BlockPos pos) {
        return 0.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 1.0);
    }

    public void knockback(double strength, double xRatio, double zRatio) {
    }

    public boolean hurt(DamageSource source, float damage) {
        Player player;
        ItemStack heldStack;
        float input = damage;
        Entity entity = source.getEntity();
        if (entity instanceof Player && (heldStack = (player = (Player)entity).getItemInHand(player.getUsedItemHand())).canPerformAction(ItemAbilities.SHOVEL_DIG)) {
            input *= 1.5f;
        }
        return super.hurt(source, input);
    }

    public void aiStep() {
        super.aiStep();
    }

    private void spawnMandragora() {
        Mandragora mandragora;
        if (this.level().getDifficulty() != Difficulty.PEACEFUL && (mandragora = (Mandragora)GaiaRegistry.MANDRAGORA.getEntityType().create(this.level())) != null) {
            mandragora.moveTo(this.blockPosition(), 0.0f, 0.0f);
            mandragora.finalizeSpawn((ServerLevelAccessor)((ServerLevel)this.level()), this.level().getCurrentDifficultyAt(this.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
            this.level().addFreshEntity((Entity)mandragora);
        }
        this.level().broadcastEntityEvent((Entity)this, (byte)6);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        this.yBodyRot = 180.0f;
        this.yBodyRotO = 180.0f;
        this.setYRot(180.0f);
        this.yRotO = 180.0f;
        this.yHeadRot = 180.0f;
        this.yHeadRotO = 180.0f;
        return data;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    protected void playParticleEffect(boolean smoke) {
        SimpleParticleType particle = ParticleTypes.SMOKE;
        if (!smoke) {
            particle = ParticleTypes.POOF;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)particle, this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.getY() + 0.5 + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), d0, d1, d2);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 7) {
            this.playParticleEffect(true);
        } else if (id == 6) {
            this.playParticleEffect(false);
        } else {
            super.handleEntityEvent(id);
        }
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.GLASS_BREAK;
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource damageSource, boolean killedByPlayer) {
        if (killedByPlayer) {
            if (this.random.nextInt(4) == 0) {
                if (!this.level().isClientSide) {
                    this.spawnMandragora();
                    this.playSound((SoundEvent)GaiaSounds.MANDRAGORA_SCREAM.get(), 2.0f, 2.0f);
                }
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
                super.dropCustomDeathLoot(serverLevel, damageSource, killedByPlayer);
            }
        } else {
            super.dropCustomDeathLoot(serverLevel, damageSource, killedByPlayer);
        }
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return false;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public int getMaxHeadXRot() {
        return 180;
    }

    public int getMaxHeadYRot() {
        return 180;
    }

    public void push(Entity entity) {
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public float getPickRadius() {
        return 0.0f;
    }

    public static boolean checkCyanFlowerSpawnRules(EntityType<? extends AgeableMob> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return CyanFlower.checkDaysPassed(levelAccessor) && CyanFlower.checkTagBlocks(levelAccessor, pos, GaiaTags.FLOWER_SPAWNABLE_ON) && CyanFlower.checkAboveSeaLevel(levelAccessor, pos) && CyanFlower.checkAnyLightMonsterSpawnRules(entityType, (LevelAccessor)levelAccessor, spawnType, pos, random);
    }
}

