/*
 * Decompiled with CFR 0.152.
 */
package gaia.item.accessory;

import gaia.item.accessory.AbstractAccessoryItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class KnucklesItem
extends AbstractAccessoryItem {
    private static final int damage = 2;
    private static final ResourceLocation BOOST_UUID = ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)"knuckles_damage_boost");
    private static final AttributeModifier BOOST = new AttributeModifier(BOOST_UUID, 2.0, AttributeModifier.Operation.ADD_VALUE);

    public KnucklesItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, list, flag);
        list.add((Component)Component.translatable((String)"text.grimoireofgaia.charm.tag").withStyle(ChatFormatting.YELLOW));
        if (Screen.hasShiftDown()) {
            list.add((Component)Component.translatable((String)"text.grimoireofgaia.charm.damage", (Object[])new Object[]{2}));
        } else {
            list.add((Component)Component.translatable((String)"text.grimoireofgaia.hold_shift").withStyle(ChatFormatting.ITALIC));
        }
    }

    @Override
    public boolean isModifier() {
        return true;
    }

    @Override
    public void doEffect(LivingEntity player, ItemStack stack) {
    }

    @Override
    public void applyModifier(LivingEntity player, ItemStack stack) {
        AttributeInstance attribute = player.getAttribute(Attributes.ATTACK_DAMAGE);
        if (!attribute.hasModifier(BOOST_UUID)) {
            attribute.addTransientModifier(BOOST);
        }
    }

    @Override
    public void removeModifier(LivingEntity player, ItemStack stack) {
        AttributeInstance attribute = player.getAttribute(Attributes.ATTACK_DAMAGE);
        if (attribute.hasModifier(BOOST_UUID)) {
            attribute.removeModifier(BOOST_UUID);
        }
    }
}

