/*
 * Decompiled with CFR 0.152.
 */
package gaia.item.edible;

import gaia.entity.AbstractGaiaEntity;
import gaia.registry.GaiaRegistry;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class MonsterFeedItem
extends Item {
    public MonsterFeedItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, list, flag);
        list.add((Component)Component.translatable((String)"text.grimoireofgaia.monster_feed.desc"));
        if (stack.is((Item)GaiaRegistry.MONSTER_FEED.get())) {
            list.add((Component)Component.translatable((String)"text.grimoireofgaia.food_monster_feed.desc"));
        } else {
            list.add((Component)Component.translatable((String)"text.grimoireofgaia.premium_food_monster_feed.desc"));
        }
        list.add((Component)Component.translatable((String)"item.grimoireofgaia.food_monster_feed2.desc"));
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity livingEntity, InteractionHand interactionHand) {
        AbstractGaiaEntity gaiaEntity;
        if (livingEntity instanceof AbstractGaiaEntity && !(gaiaEntity = (AbstractGaiaEntity)livingEntity).isFriendly()) {
            gaiaEntity.level().broadcastEntityEvent((Entity)gaiaEntity, (byte)8);
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            gaiaEntity.setFriendly(true, player.getUUID());
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
        }
        return InteractionResult.PASS;
    }
}

