/*
 * Decompiled with CFR 0.152.
 */
package gaia.item.edible;

import gaia.config.GaiaConfig;
import gaia.item.edible.EdibleEffectItem;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class XPEdibleItem
extends EdibleEffectItem {
    private final Function<RandomSource, Integer> experienceFunction;

    public XPEdibleItem(Item.Properties properties, Function<RandomSource, Integer> experienceFunction) {
        super(properties);
        this.experienceFunction = experienceFunction;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, list, flag);
        if (!GaiaConfig.CLIENT.hideFoodXpTooltips.getAsBoolean()) {
            list.add((Component)Component.translatable((String)"text.grimoireofgaia.gain_experience"));
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.rewardEXP(player, this.experienceFunction.apply(level.random));
        }
        return super.finishUsingItem(stack, level, entity);
    }
}

