/*
 * Decompiled with CFR 0.152.
 */
package gaia.item.fuel;

import gaia.item.fuel.FuelItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FireshardItem
extends FuelItem {
    public FireshardItem(Item.Properties properties) {
        super(properties, 20000);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult blockHitResult = FireshardItem.getPlayerPOVCollisionHitResult(level, player, ClipContext.Fluid.NONE);
        if (blockHitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        BlockPos blockpos = blockHitResult.getBlockPos();
        Direction direction = blockHitResult.getDirection();
        BlockPos relativePos = blockpos.relative(direction);
        if (level.mayInteract(player, blockpos) && player.mayUseItemAt(relativePos, direction, itemstack)) {
            BlockPos relativePos2;
            BlockState state = level.getBlockState(blockpos);
            BlockPos blockPos = relativePos2 = this.canBlockContainFluid(player, level, blockpos, state) ? blockpos : relativePos;
            if (level.setBlock(relativePos2, Fluids.LAVA.defaultFluidState().createLegacyBlock(), 11) && !state.getFluidState().isSource()) {
                level.playSound(player, relativePos2, SoundEvents.GHAST_SCREAM, SoundSource.BLOCKS, 0.4f, 0.8f);
                level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PLACE, relativePos2);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, relativePos2, itemstack);
                }
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                return InteractionResultHolder.consume((Object)itemstack);
            }
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public static BlockHitResult getPlayerPOVCollisionHitResult(Level level, Player player, ClipContext.Fluid fluid) {
        float f = player.getXRot();
        float f1 = player.getYRot();
        Vec3 vec3 = player.getEyePosition();
        float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        AttributeInstance reachInstance = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        double d0 = 4.5;
        if (reachInstance != null) {
            d0 = reachInstance.getValue();
        }
        Vec3 vec31 = vec3.add((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return level.clip(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, fluid, (Entity)player));
    }

    private boolean canBlockContainFluid(Player player, Level level, BlockPos posIn, BlockState blockstate) {
        return blockstate.getBlock() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.getBlock()).canPlaceLiquid(player, (BlockGetter)level, posIn, blockstate, (Fluid)Fluids.LAVA);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, list, flag);
        list.add((Component)Component.translatable((String)"text.grimoireofgaia.fireshard.desc").withStyle(ChatFormatting.ITALIC));
    }
}

