/*
 * Decompiled with CFR 0.152.
 */
package gaia.item.weapon;

import gaia.entity.projectile.MagicProjectile;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaSounds;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;

public class MagicStaffItem
extends Item {
    public MagicStaffItem(Item.Properties properties, Supplier<EntityType<? extends Mob>> typeSupplier) {
        super(properties);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeLeft) {
        super.releaseUsing(stack, level, livingEntity, timeLeft);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairStack) {
        return repairStack.is(Tags.Items.GEMS_LAPIS);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            stack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            if (!level.isClientSide) {
                livingEntity.playSound((SoundEvent)GaiaSounds.GAIA_SHOOT.get(), 1.0f, 1.0f / (livingEntity.getRandom().nextFloat() * 0.4f + 0.8f));
                MagicProjectile magic = (MagicProjectile)GaiaRegistry.MAGIC.get().create(level);
                if (magic != null) {
                    magic.setOwner((Entity)livingEntity);
                    magic.setDamage(4.0f);
                    magic.setPos(livingEntity.getX(), livingEntity.getY(0.5) + 0.5, livingEntity.getZ());
                    magic.setOwner((Entity)livingEntity);
                    magic.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
                    livingEntity.level().addFreshEntity((Entity)magic);
                }
            }
            player.playSound(SoundEvents.CHICKEN_EGG, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        } else {
            stack.shrink(1);
        }
        return super.finishUsingItem(stack, level, livingEntity);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.getItemInHand(interactionHand);
        player.startUsingItem(interactionHand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, list, flag);
        list.add((Component)Component.translatable((String)"text.grimoireofgaia.magic_staff.desc").withStyle(ChatFormatting.GRAY));
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 30;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment != Enchantments.MENDING && super.isPrimaryItemFor(stack, enchantment);
    }
}

