/*
 * Decompiled with CFR 0.152.
 */
package gaia.item.weapon.book;

import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaSounds;
import gaia.util.RandomUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BuffBookItem
extends Item {
    public BuffBookItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, list, flag);
        Player player = RandomUtil.getPlayer();
        if (player == null) {
            return;
        }
        if (player.getOffhandItem() == stack) {
            list.add((Component)Component.translatable((String)"text.grimoireofgaia.bless.off_hand").withStyle(ChatFormatting.YELLOW));
        } else {
            list.add((Component)Component.translatable((String)"text.grimoireofgaia.bless.main_hand").withStyle(ChatFormatting.YELLOW));
        }
        list.add((Component)Component.translatable((String)((MobEffect)MobEffects.DAMAGE_BOOST.value()).getDescriptionId()).append(" I(1:00)"));
        list.add((Component)Component.translatable((String)((MobEffect)MobEffects.DAMAGE_RESISTANCE.value()).getDescriptionId()).append(" (1:00)"));
        list.add((Component)Component.translatable((String)((MobEffect)MobEffects.REGENERATION.value()).getDescriptionId()).append(" IV (0:04)"));
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        attacker.level().playSound((Player)null, attacker.getX(), attacker.getY(), attacker.getZ(), (SoundEvent)GaiaSounds.BOOK_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        target.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 600, 0));
        target.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 600, 0));
        target.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 80, 3));
        return true;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity livingEntity) {
        if (state.getDestroySpeed((BlockGetter)level, pos) != 0.0f) {
            stack.hurtAndBreak(2, livingEntity, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairStack) {
        return repairStack.is((Item)GaiaRegistry.QUILL.get());
    }
}

