/*
 * Decompiled with CFR 0.152.
 */
package gaia.item.weapon.book;

import gaia.item.weapon.book.WeaponBookItem;
import gaia.registry.GaiaSounds;
import gaia.util.RandomUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;

public class EnderBookItem
extends WeaponBookItem {
    public EnderBookItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, list, flag);
        Player player = RandomUtil.getPlayer();
        if (player == null) {
            return;
        }
        if (player.getOffhandItem() == stack) {
            list.add((Component)Component.translatable((String)"text.grimoireofgaia.bless.off_hand").withStyle(ChatFormatting.YELLOW));
        } else {
            list.add((Component)Component.translatable((String)"text.grimoireofgaia.bless.main_hand").withStyle(ChatFormatting.YELLOW));
        }
        list.add((Component)Component.translatable((String)((MobEffect)MobEffects.BLINDNESS.value()).getDescriptionId()).append(" II (0:04)"));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            stack.hurtAndBreak(5, (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
        player.causeFoodExhaustion(5.0f);
        level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDER_PEARL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (player.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            ThrownEnderpearl enderpearl = new ThrownEnderpearl(level, (LivingEntity)player);
            enderpearl.setItem(new ItemStack((ItemLike)Items.ENDER_PEARL));
            enderpearl.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)enderpearl);
        }
        player.getCooldowns().addCooldown((Item)this, 60);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        super.hurtEnemy(stack, target, attacker);
        attacker.level().playSound((Player)null, attacker.getX(), attacker.getY(), attacker.getZ(), (SoundEvent)GaiaSounds.BOOK_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        target.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 80, 1));
        return true;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairStack) {
        return repairStack.is(Tags.Items.ENDER_PEARLS);
    }
}

