/*
 * Decompiled with CFR 0.152.
 */
package gaia.registry.helper;

import gaia.registry.GaiaRegistry;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public class PropReg<T extends Mob> {
    protected final String name;
    protected final Supplier<EntityType<? extends T>> entityType;
    protected final DeferredItem<Item> spawnEgg;

    @NotNull
    public String getName() {
        return this.name;
    }

    public EntityType<? extends T> getEntityType() {
        return this.entityType.get();
    }

    public DeferredItem<Item> getSpawnEgg() {
        return this.spawnEgg;
    }

    public PropReg(String name, EntityType.Builder<T> builder, int backgroundColor, int highlightColor) {
        this.name = name;
        this.entityType = GaiaRegistry.ENTITIES.register(name, () -> builder.build(name));
        this.spawnEgg = GaiaRegistry.ITEMS.register(name + "_spawn_egg", () -> new DeferredSpawnEggItem(this.entityType, backgroundColor, highlightColor, new Item.Properties()));
    }
}

