/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.CobblestoneGolem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class CobblestoneGolemModel
extends EntityModel<CobblestoneGolem> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart rightarm;
    private final ModelPart leftarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;

    public CobblestoneGolemModel(ModelPart root) {
        this.root = root.m_171324_("cobblestone_golem");
        ModelPart body = this.root.m_171324_("bodymid").m_171324_("bodylower").m_171324_("body");
        this.head = body.m_171324_("head");
        this.rightarm = body.m_171324_("rightarm");
        this.leftarm = body.m_171324_("leftarm");
        this.rightleg = this.root.m_171324_("rightleg");
        this.leftleg = this.root.m_171324_("leftleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition cobblestone_golem = partdefinition.m_171599_("cobblestone_golem", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)-2.0f));
        PartDefinition bodymid = cobblestone_golem.m_171599_("bodymid", CubeListBuilder.m_171558_().m_171514_(0, 61).m_171481_(-6.5f, 14.0f, 1.0f, 13.0f, 7.0f, 7.0f), PartPose.m_171419_((float)0.0f, (float)-31.0f, (float)-2.5f));
        PartDefinition bodylower = bodymid.m_171599_("bodylower", CubeListBuilder.m_171558_().m_171514_(0, 45).m_171481_(-6.0f, -10.0f, -6.0f, 12.0f, 10.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)7.6f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition body = bodylower.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171481_(-7.0f, -11.0f, -7.0f, 14.0f, 11.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -8.0f, -8.0f, 8.0f, 8.0f, 8.0f).m_171514_(32, 0).m_171481_(-2.0f, -10.0f, -9.0f, 4.0f, 4.0f, 1.0f).m_171514_(32, 5).m_171481_(-1.0f, -5.0f, -9.0f, 2.0f, 3.0f, 1.0f).m_171514_(32, 9).m_171481_(-2.0f, -1.0f, -9.0f, 4.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)-7.1f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = body.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(45, 17).m_171481_(-4.0f, -1.0f, -2.0f, 5.0f, 11.0f, 5.0f), PartPose.m_171423_((float)-7.0f, (float)-8.5f, (float)-3.5f, (float)-0.5236f, (float)0.2618f, (float)0.0f));
        PartDefinition rightshoulder = rightarm.m_171599_("rightshoulder", CubeListBuilder.m_171558_().m_171514_(81, 0).m_171480_().m_171481_(-7.0f, -4.0f, -4.5f, 9.0f, 8.0f, 9.0f).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition rightarmlower = rightarm.m_171599_("rightarmlower", CubeListBuilder.m_171558_().m_171514_(45, 33).m_171481_(-2.505f, 0.0f, -5.0f, 5.0f, 11.0f, 5.0f).m_171514_(73, 49).m_171480_().m_171481_(-3.505f, 2.5f, -6.0f, 7.0f, 9.0f, 7.0f).m_171555_(false), PartPose.m_171423_((float)-1.5f, (float)10.0f, (float)3.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = body.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(45, 17).m_171481_(-1.0f, -1.0f, -2.0f, 5.0f, 11.0f, 5.0f), PartPose.m_171423_((float)7.0f, (float)-8.5f, (float)-3.5f, (float)-0.5236f, (float)-0.2618f, (float)0.0f));
        PartDefinition leftshoulder = leftarm.m_171599_("leftshoulder", CubeListBuilder.m_171558_().m_171514_(45, 0).m_171480_().m_171481_(-2.0f, -4.0f, -4.5f, 9.0f, 8.0f, 9.0f).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition leftarmlower = leftarm.m_171599_("leftarmlower", CubeListBuilder.m_171558_().m_171514_(45, 33).m_171481_(-2.495f, 0.0f, -4.9f, 5.0f, 11.0f, 5.0f).m_171514_(45, 49).m_171480_().m_171481_(-3.495f, 2.5f, -5.9f, 7.0f, 9.0f, 7.0f).m_171555_(false), PartPose.m_171423_((float)1.5f, (float)10.0f, (float)2.9f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition back = body.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-6.0f, -5.0f, -5.0f, 12.0f, 5.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)-11.0f, (float)1.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg = cobblestone_golem.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(45, 65).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f), PartPose.m_171419_((float)-3.0f, (float)-15.0f, (float)2.0f));
        PartDefinition rightleglower = rightleg.m_171599_("rightleglower", CubeListBuilder.m_171558_().m_171514_(45, 79).m_171481_(-2.5f, -5.0f, 0.0f, 5.0f, 10.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)-1.0f));
        PartDefinition leftleg = cobblestone_golem.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(45, 65).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f), PartPose.m_171419_((float)3.0f, (float)-15.0f, (float)2.0f));
        PartDefinition leftleglower = leftleg.m_171599_("leftleglower", CubeListBuilder.m_171558_().m_171514_(45, 79).m_171481_(-2.5f, -5.0f, 0.0f, 5.0f, 10.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)-1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)128);
    }

    public void prepareMobModel(CobblestoneGolem cobbleGolem, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_((Entity)cobbleGolem, limbSwing, limbSwingAmount, partialTick);
        int i = cobbleGolem.getAttackAnimationTick();
        float rotation = 0.0f;
        if (i > 0) {
            this.leftarm.f_104203_ = rotation - 2.0f + 1.5f * Mth.m_14156_((float)((float)i - partialTick), (float)10.0f);
            this.rightarm.f_104203_ = rotation - 2.0f + 1.5f * Mth.m_14156_((float)((float)i - partialTick), (float)10.0f);
        } else {
            this.leftarm.f_104203_ = rotation + (-0.2f + 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f)) * limbSwingAmount;
            this.rightarm.f_104203_ = rotation + (-0.2f - 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f)) * limbSwingAmount;
        }
    }

    public void setupAnim(CobblestoneGolem cobbleGolem, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f - 0.2617994f;
        this.leftarm.f_104205_ = 0.0f;
        this.rightarm.f_104205_ = 0.0f;
        this.leftarm.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f - 0.2617994f;
        this.leftarm.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
        this.rightarm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f - 0.2617994f;
        this.rightarm.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
        this.rightleg.f_104203_ = -1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.rightleg.f_104203_ -= 0.1745329f;
        this.leftleg.f_104203_ = 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.leftleg.f_104203_ -= 0.1745329f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

