/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.Creep;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class CreepModel
extends EntityModel<Creep> {
    private final ModelPart root;
    private final ModelPart body1;
    private final ModelPart head1;
    private final ModelPart head2;
    private final ModelPart head3;
    private final ModelPart smallhead1;
    private final ModelPart smallhead2;
    private final ModelPart smallhead3;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;
    private final ModelPart leg5;
    private final ModelPart leg6;

    public CreepModel(ModelPart root) {
        this.root = root.m_171324_("creep");
        this.body1 = this.root.m_171324_("body1");
        ModelPart body2 = this.body1.m_171324_("body2");
        this.head1 = body2.m_171324_("head1");
        this.head2 = body2.m_171324_("head2");
        this.head3 = body2.m_171324_("head3");
        this.smallhead1 = body2.m_171324_("smallhead1");
        this.smallhead2 = body2.m_171324_("smallhead2");
        this.smallhead3 = body2.m_171324_("smallhead3");
        this.leg1 = this.root.m_171324_("leg1");
        this.leg2 = this.root.m_171324_("leg2");
        this.leg3 = this.root.m_171324_("leg3");
        this.leg4 = this.root.m_171324_("leg4");
        this.leg5 = this.root.m_171324_("leg5");
        this.leg6 = this.root.m_171324_("leg6");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation deformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition creep = partdefinition.m_171599_("creep", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body1 = creep.m_171599_("body1", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f, deformation), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition body2 = body1.m_171599_("body2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition body2_r1 = body2.m_171599_("body2_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, deformation), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)1.5708f, (float)-0.3491f, (float)0.0f));
        PartDefinition head1 = body2.m_171599_("head1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -10.0f, 8.0f, 8.0f, 8.0f, deformation), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.6109f, (float)-0.7854f, (float)-0.0873f));
        PartDefinition head2 = body2.m_171599_("head2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -10.0f, 8.0f, 8.0f, 8.0f, deformation), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.2618f, (float)0.7854f, (float)0.0873f));
        PartDefinition head3 = body2.m_171599_("head3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -10.0f, 8.0f, 8.0f, 8.0f, deformation), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.4363f, (float)3.1416f, (float)0.0f));
        PartDefinition smallhead1 = body2.m_171599_("smallhead1", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.0f, -3.0f, -9.0f, 6.0f, 6.0f, 6.0f, deformation), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.2618f, (float)-2.0944f, (float)0.0873f));
        PartDefinition smallhead2 = body2.m_171599_("smallhead2", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.0f, -3.0f, -9.0f, 6.0f, 6.0f, 6.0f, deformation), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.1745f, (float)2.0944f, (float)-0.0873f));
        PartDefinition smallhead3 = body2.m_171599_("smallhead3", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.0f, -3.0f, -9.0f, 6.0f, 6.0f, 6.0f, deformation), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0873f));
        PartDefinition leg1 = creep.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(32, 12).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, deformation), PartPose.m_171423_((float)2.5f, (float)-6.0f, (float)-4.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition leg2 = creep.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(32, 12).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, deformation), PartPose.m_171423_((float)-2.5f, (float)-6.0f, (float)-4.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition leg3 = creep.m_171599_("leg3", CubeListBuilder.m_171558_().m_171514_(32, 12).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, deformation), PartPose.m_171423_((float)-5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition leg4 = creep.m_171599_("leg4", CubeListBuilder.m_171558_().m_171514_(48, 12).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, deformation), PartPose.m_171423_((float)-2.5f, (float)-6.0f, (float)4.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition leg5 = creep.m_171599_("leg5", CubeListBuilder.m_171558_().m_171514_(48, 12).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, deformation), PartPose.m_171423_((float)2.5f, (float)-6.0f, (float)4.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition leg6 = creep.m_171599_("leg6", CubeListBuilder.m_171558_().m_171514_(32, 12).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, deformation), PartPose.m_171423_((float)5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(Creep entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head1.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.8f + (float)Math.PI)) * 0.4f * limbSwingAmount * 0.5f;
        this.head2.f_104203_ = this.head1.f_104203_ - 0.2617994f;
        this.head3.f_104203_ = this.head1.f_104203_ - 0.4363323f;
        this.head1.f_104203_ -= 0.6108652f;
        this.smallhead1.f_104203_ = Mth.m_14089_((float)(ageInTicks * 1.2f + (float)Math.PI)) * 0.6f * limbSwingAmount * 0.5f;
        this.smallhead2.f_104203_ = this.smallhead1.f_104203_ - 0.1745329f;
        this.smallhead3.f_104203_ = this.smallhead1.f_104203_ + 0.0872665f;
        this.smallhead1.f_104203_ -= 0.2617994f;
        this.body1.f_104204_ = netHeadYaw / 57.295776f;
        this.body1.f_104203_ = headPitch / 57.295776f;
        this.leg1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg2.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg3.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg4.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg5.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg6.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

