/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Siren;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.BowItem;

public class SirenModel
extends EntityModel<Siren>
implements HeadedModel,
ArmedModel {
    private static final double CYCLES_PER_BLOCK = 0.1;
    private final float[][] undulationCycle = new float[][]{{5.0f, 0.0f, -11.25f, -45.0f, -22.5f, 0.0f, 22.5f, 45.0f}, {10.0f, 10.0f, 0.0f, -22.5f, -45.0f, -22.5f, 0.0f, 22.5f}, {5.0f, 20.0f, 11.25f, 0.0f, -22.5f, -45.0f, -22.5f, 0.0f}, {0.0f, 10.0f, 22.5f, 22.5f, 0.0f, -22.5f, -45.0f, -22.5f}, {-5.0f, 0.0f, 11.25f, 45.0f, 22.5f, 0.0f, -22.5f, -45.0f}, {-10.0f, -10.0f, 0.0f, 22.5f, 45.0f, 22.5f, 0.0f, -22.5f}, {-5.0f, -20.0f, -11.25f, 0.0f, 22.5f, 45.0f, 22.5f, 0.0f}, {0.0f, -10.0f, -22.5f, -22.5f, 0.0f, 22.5f, 45.0f, 22.5f}};
    private final ModelPart root;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart hair1;
    private final ModelPart hair2;
    private final ModelPart chest;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftarmextra;
    private final ModelPart rightarmextra;
    private final ModelPart leftarmextralower;
    private final ModelPart rightarmextralower;
    private final ModelPart[] tails = new ModelPart[8];

    public SirenModel(ModelPart root) {
        this.root = root.m_171324_("siren");
        ModelPart bodybottom = this.root.m_171324_("bodybottom");
        this.bodytop = bodybottom.m_171324_("bodymiddle").m_171324_("bodytop");
        ModelPart neck = this.bodytop.m_171324_("neck");
        this.head = neck.m_171324_("head");
        this.headeyes = this.head.m_171324_("headeyes");
        this.hair1 = neck.m_171324_("hair1");
        this.hair2 = this.hair1.m_171324_("hair2");
        this.chest = this.bodytop.m_171324_("chest");
        this.leftarm = this.bodytop.m_171324_("leftarm");
        this.rightarm = this.bodytop.m_171324_("rightarm");
        this.leftarmextra = this.bodytop.m_171324_("leftarmextra");
        this.rightarmextra = this.bodytop.m_171324_("rightarmextra");
        this.leftarmextralower = this.leftarmextra.m_171324_("leftarmextralower");
        this.rightarmextralower = this.rightarmextra.m_171324_("rightarmextralower");
        for (int i = 0; i < this.tails.length; ++i) {
            int index = i + 1;
            this.tails[i] = index == 1 ? this.root.m_171324_("tail" + index) : this.tails[i - 1].m_171324_("tail" + index);
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition siren = partdefinition.m_171599_("siren", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)27.0f, (float)0.0f));
        PartDefinition bodybottom = siren.m_171599_("bodybottom", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171481_(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)-13.5f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.m_171599_("bodymiddle", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-2.0f, -2.5f, -1.45f, 4.0f, 3.0f, 2.0f).m_171514_(0, 25).m_171481_(-0.5f, -2.0f, -1.55f, 1.0f, 2.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)-1.5f, (float)0.45f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop = bodymiddle.m_171599_("bodytop", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 3.0f).m_171514_(36, 42).m_171488_(-4.5f, -6.0f, -3.0f, 9.0f, 5.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)0.55f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).m_171514_(36, 0).m_171481_(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headeyes = head.m_171599_("headeyes", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-3.0f, -6.0f, -3.1f, 6.0f, 6.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition finright = head.m_171599_("finright", CubeListBuilder.m_171558_().m_171514_(36, 32).m_171481_(0.0f, -3.0f, 0.0f, 0.0f, 5.0f, 5.0f), PartPose.m_171423_((float)-3.0f, (float)-3.0f, (float)-2.5f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition finleft = head.m_171599_("finleft", CubeListBuilder.m_171558_().m_171514_(36, 32).m_171481_(0.0f, -3.0f, 0.0f, 0.0f, 5.0f, 5.0f), PartPose.m_171423_((float)3.0f, (float)-3.0f, (float)-2.5f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition hair1 = neck.m_171599_("hair1", CubeListBuilder.m_171558_().m_171514_(36, 14).m_171481_(-4.0f, -6.0f, 1.0f, 8.0f, 8.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hair2 = hair1.m_171599_("hair2", CubeListBuilder.m_171558_().m_171514_(36, 25).m_171481_(-4.5f, -1.0f, -1.5f, 9.0f, 9.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)3.0f));
        PartDefinition chest = bodytop.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171481_(-2.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).m_171514_(0, 36).m_171480_().m_171481_(0.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-5.5f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(16, 36).m_171481_(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171423_((float)-2.5f, (float)-4.5f, (float)-0.5f, (float)0.0873f, (float)0.0f, (float)0.3491f));
        PartDefinition rightarmlower = rightarm.m_171599_("rightarmlower", CubeListBuilder.m_171558_().m_171514_(16, 44).m_171481_(-1.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171419_((float)-1.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftarm = bodytop.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(16, 12).m_171481_(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171423_((float)2.5f, (float)-4.5f, (float)-0.5f, (float)0.0873f, (float)0.0f, (float)-0.3491f));
        PartDefinition leftarmlower = leftarm.m_171599_("leftarmlower", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171481_(-1.0f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171419_((float)1.005f, (float)5.0f, (float)1.0f));
        PartDefinition rightarmextra = bodytop.m_171599_("rightarmextra", CubeListBuilder.m_171558_().m_171514_(24, 36).m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171423_((float)-2.5f, (float)-3.5f, (float)0.5f, (float)0.2618f, (float)0.0f, (float)0.1745f));
        PartDefinition rightarmextralower = rightarmextra.m_171599_("rightarmextralower", CubeListBuilder.m_171558_().m_171514_(24, 44).m_171481_(-1.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftarmextra = bodytop.m_171599_("leftarmextra", CubeListBuilder.m_171558_().m_171514_(24, 12).m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171423_((float)2.5f, (float)-3.5f, (float)0.5f, (float)0.2618f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftarmextralower = leftarmextra.m_171599_("leftarmextralower", CubeListBuilder.m_171558_().m_171514_(24, 20).m_171481_(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)1.0f));
        PartDefinition tail1 = siren.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171481_(-3.5f, -1.0f, -2.5f, 7.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)0.5f));
        PartDefinition tail2 = tail1.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(64, 8).m_171481_(-3.0f, 0.0f, 0.0f, 6.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-2.5f));
        PartDefinition tail3 = tail2.m_171599_("tail3", CubeListBuilder.m_171558_().m_171514_(64, 16).m_171481_(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition tail4 = tail3.m_171599_("tail4", CubeListBuilder.m_171558_().m_171514_(64, 16).m_171481_(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition tail5 = tail4.m_171599_("tail5", CubeListBuilder.m_171558_().m_171514_(64, 24).m_171481_(-2.0f, 0.0f, 0.5f, 4.0f, 4.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition tail6 = tail5.m_171599_("tail6", CubeListBuilder.m_171558_().m_171514_(64, 24).m_171481_(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.5f));
        PartDefinition tail7 = tail6.m_171599_("tail7", CubeListBuilder.m_171558_().m_171514_(64, 31).m_171481_(-1.5f, 0.0f, 0.5f, 3.0f, 3.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition tail8 = tail7.m_171599_("tail8", CubeListBuilder.m_171558_().m_171514_(64, 36).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Siren siren, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_((Entity)siren, limbSwing, limbSwingAmount, partialTick);
        this.chest.f_104207_ = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !siren.m_6162_();
    }

    public void setupAnim(Siren siren, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.f_104207_ = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        this.hair1.f_104204_ = this.head.f_104204_;
        this.hair1.f_104203_ = this.head.f_104203_;
        this.hair2.f_104203_ = this.head.f_104203_ * 0.75f;
        float armextraDefaultAngleX = 0.261799f;
        this.rightarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
        this.leftarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
        this.rightarm.f_104205_ = 0.0f;
        this.leftarm.f_104205_ = 0.0f;
        if (siren.m_5912_() && siren.m_21205_().m_41720_() instanceof BowItem) {
            this.holdingBow(ageInTicks);
        } else if (this.f_102608_ > 0.0f) {
            this.holdingMelee();
        }
        this.rightarm.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.4363323f;
        this.rightarm.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.025f;
        this.leftarm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.4363323f;
        this.leftarm.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.025f;
        this.rightarmextra.f_104205_ = armextraDefaultAngleX;
        this.leftarmextra.f_104205_ = -armextraDefaultAngleX;
        this.rightarmextra.f_104203_ = armextraDefaultAngleX;
        this.leftarmextra.f_104203_ = armextraDefaultAngleX;
        this.rightarmextralower.f_104203_ = -armextraDefaultAngleX;
        this.leftarmextralower.f_104203_ = -armextraDefaultAngleX;
        this.tails[0].f_104203_ = -0.1308997f;
        this.tails[1].f_104203_ = 0.3926991f;
        this.tails[2].f_104203_ = 0.3926991f;
        this.tails[3].f_104203_ = 0.785398f;
        this.tails[7].f_104203_ = 0.3926991f;
        int cycleIndex = (int)((double)limbSwing * 0.1 % (double)this.undulationCycle.length);
        this.tails[4].f_104205_ = 0.3f * Mth.m_14089_((float)(limbSwing * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][4])));
        this.tails[5].f_104205_ = 0.3f * Mth.m_14089_((float)(limbSwing * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][5])));
        this.tails[6].f_104205_ = 0.3f * Mth.m_14089_((float)(limbSwing * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][6])));
        this.tails[7].f_104205_ = 0.3f * Mth.m_14089_((float)(limbSwing * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][7])));
    }

    private void holdingBow(float ageInTicks) {
        float f = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI));
        float f1 = Mth.m_14031_((float)((1.0f - (1.0f - this.f_102608_) * (1.0f - this.f_102608_)) * (float)Math.PI));
        this.rightarm.f_104205_ = -0.3f;
        this.leftarm.f_104205_ = 0.3f;
        this.rightarm.f_104204_ = -(0.1f - f * 0.6f);
        this.leftarm.f_104204_ = 0.3f - f * 0.6f;
        this.rightarm.f_104203_ = -1.5707964f;
        this.leftarm.f_104203_ = -1.5707964f;
        this.rightarm.f_104203_ -= f * 1.2f - f1 * 0.4f;
        this.leftarm.f_104203_ -= f * 1.2f - f1 * 0.4f;
        this.rightarm.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.leftarm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.rightarm.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
        this.leftarm.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.f_102608_;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.m_14031_((float)(f6 * (float)Math.PI));
        float f8 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
        this.rightarm.f_104203_ = (float)((double)this.rightarm.f_104203_ - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.f_104203_ += this.bodytop.f_104204_ * 2.0f;
        this.rightarm.f_104205_ = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        poseStack.m_85837_(-0.125, 0.5, 0.0);
        if (arm == HumanoidArm.LEFT) {
            poseStack.m_85837_(0.125, 0.0, 0.0625);
        }
        this.getArm(arm).m_104299_(poseStack);
    }
}

