/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class GaiaItemInHandLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final HumanoidArm humanoidArm;
    private final ItemInHandRenderer renderer;

    public GaiaItemInHandLayer(RenderLayerParent<T, M> renderLayerParent, HumanoidArm hand, ItemInHandRenderer renderer) {
        super(renderLayerParent);
        this.humanoidArm = hand;
        this.renderer = renderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack heldStack;
        boolean rightHanded = this.humanoidArm == HumanoidArm.RIGHT;
        ItemStack itemStack = heldStack = rightHanded ? livingEntity.m_21205_() : livingEntity.m_21206_();
        if (!heldStack.m_41619_()) {
            poseStack.m_85836_();
            if (this.m_117386_().f_102610_) {
                float f = 0.5f;
                poseStack.m_85837_(0.0, 0.75, 0.0);
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            }
            this.renderArmWithItem((LivingEntity)livingEntity, heldStack, rightHanded ? ItemDisplayContext.THIRD_PERSON_RIGHT_HAND : ItemDisplayContext.THIRD_PERSON_LEFT_HAND, poseStack, bufferSource, packedLight);
            poseStack.m_85849_();
        }
    }

    protected void renderArmWithItem(LivingEntity livingEntity, ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (!stack.m_41619_()) {
            poseStack.m_85836_();
            ((ArmedModel)this.m_117386_()).m_6002_(this.humanoidArm, poseStack);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            boolean flag = this.humanoidArm == HumanoidArm.LEFT;
            poseStack.m_85837_((double)((float)(flag ? -1 : 1) / 16.0f), 0.125, -0.625);
            this.renderer.m_269530_(livingEntity, stack, transformType, flag, poseStack, bufferSource, packedLight);
            poseStack.m_85849_();
        }
    }
}

