/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class Anubis
extends AbstractGaiaEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> MALE = SynchedEntityData.m_135353_(Anubis.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(Anubis.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.275, 20, 60, 15.0f);
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.275, true);
    private int switchHealth;
    private int spawn;
    private int spawnTimer;
    private boolean animationPlay;
    private int animationTimer;

    public Anubis(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 20;
        this.switchHealth = 0;
        this.spawn = 0;
        this.spawnTimer = 0;
        this.animationPlay = false;
        this.animationTimer = 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22277_, 26.0).m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22282_, 0.25).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MALE, (Object)false);
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
    }

    public boolean isMale() {
        return (Boolean)this.f_19804_.m_135370_(MALE);
    }

    public void setMale(boolean flag) {
        this.f_19804_.m_135381_(MALE, (Object)flag);
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    public void setAnimationState(int state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.m_6469_(source, input);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (target.m_6084_()) {
            RangedUtil.magic(target, (LivingEntity)this, distanceFactor);
            this.setAnimationState(1);
            this.animationPlay = true;
            this.animationTimer = 0;
        }
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    effectTime = 5;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    effectTime = 10;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effectTime * 20, 0));
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, effectTime * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        this.beaconMonster(6, entity -> {
            if (entity instanceof Zombie || entity instanceof Skeleton) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, 1, true, true));
            }
        });
        if (this.m_21223_() < this.m_21233_() * 0.75f && this.switchHealth == 0) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.METAL_DAGGER.get()));
            this.setGoals(1);
            this.switchHealth = 1;
        }
        if (this.m_21223_() > this.m_21233_() * 0.75f && this.switchHealth == 1) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.SKELETON_STAFF.get()));
            this.setGoals(0);
            this.switchHealth = 0;
        }
        if (this.m_21223_() < this.m_21233_() * 0.75f && this.m_21223_() > 0.0f && this.spawn == 0) {
            this.setAnimationState(2);
            if (this.spawnTimer != 30) {
                ++this.spawnTimer;
            }
            if (this.spawnTimer == 30) {
                this.m_9236_().m_7605_((Entity)this, (byte)9);
                this.setAnimationState(0);
                this.setSpawn(0);
                this.spawnTimer = 0;
                this.spawn = 1;
            }
        }
        if (this.m_21223_() < this.m_21233_() * 0.25f && this.m_21223_() > 0.0f && this.spawn == 1) {
            this.setAnimationState(2);
            if (this.spawnTimer != 30) {
                ++this.spawnTimer;
            }
            if (this.spawnTimer == 30) {
                this.m_9236_().m_7605_((Entity)this, (byte)9);
                this.setAnimationState(0);
                this.setSpawn(0);
                this.spawnTimer = 0;
                this.spawn = 2;
            }
        }
        if (this.animationPlay) {
            if (this.animationTimer != 20) {
                ++this.animationTimer;
            } else {
                this.setAnimationState(0);
                this.animationPlay = false;
            }
        }
        super.m_8107_();
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.f_21345_.m_25363_((Goal)this.rangedAttackGoal);
            this.f_21345_.m_25352_(1, (Goal)this.mobAttackGoal);
        } else {
            this.f_21345_.m_25363_((Goal)this.mobAttackGoal);
            this.f_21345_.m_25352_(1, (Goal)this.rangedAttackGoal);
            this.setAnimationState(0);
            this.animationPlay = false;
            this.animationTimer = 0;
        }
    }

    private void setSpawn(int id) {
        if (!this.m_9236_().f_46443_) {
            Skeleton summon;
            BlockPos blockpos = this.m_20183_().m_7918_(-1 + this.f_19796_.m_188503_(3), 1, -1 + this.f_19796_.m_188503_(3));
            if (id == 0 && (summon = (Skeleton)EntityType.f_20524_.m_20615_(this.m_9236_())) != null) {
                summon.m_20035_(blockpos, 0.0f, 0.0f);
                summon.m_6518_((ServerLevelAccessor)((ServerLevel)this.m_9236_()), this.m_9236_().m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                summon.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)GaiaRegistry.HEADGEAR_MOB.get()));
                summon.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
                summon.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
                summon.m_21409_(EquipmentSlot.FEET, 0.0f);
                summon.m_21409_(EquipmentSlot.LEGS, 0.0f);
                summon.m_21409_(EquipmentSlot.CHEST, 0.0f);
                summon.m_21409_(EquipmentSlot.HEAD, 0.0f);
                this.m_9236_().m_7967_((Entity)summon);
            }
        }
    }

    private void setCombatTask() {
        if (this.m_21205_().m_150930_((Item)GaiaRegistry.SKELETON_STAFF.get())) {
            this.setGoals(0);
        } else {
            this.setGoals(1);
        }
    }

    @Override
    public boolean m_6549_(EntityType<?> type) {
        return super.m_6549_(type) && type != GaiaRegistry.ANUBIS.getEntityType();
    }

    protected void m_213945_(RandomSource random, DifficultyInstance instance) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.SKELETON_STAFF.get()));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        if (this.f_19796_.m_188503_(4) == 0) {
            this.setMale(true);
        }
        this.m_213945_(this.f_19796_, difficultyInstance);
        this.setCombatTask();
        return data;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Male", this.isMale());
        tag.m_128405_("AnimationState", this.getAnimationState());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Male")) {
            boolean male = tag.m_128471_("Male");
            this.setMale(male);
        }
        if (tag.m_128441_("AnimationState")) {
            int state = tag.m_128451_("AnimationState");
            this.setAnimationState(state);
        }
    }

    protected SoundEvent m_7515_() {
        return !this.isMale() ? GaiaRegistry.ANUBIS.getSay() : GaiaRegistry.ANUBIS.getMaleSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return !this.isMale() ? GaiaRegistry.ANUBIS.getHurt() : GaiaRegistry.ANUBIS.getMaleHurt();
    }

    protected SoundEvent m_5592_() {
        return !this.isMale() ? GaiaRegistry.ANUBIS.getDeath() : GaiaRegistry.ANUBIS.getMaleDeath();
    }

    protected int m_6101_() {
        return 10;
    }

    public int m_5792_() {
        return 1;
    }

    public static boolean checkAnubisSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Anubis.checkDaysPassed(levelAccessor) && Anubis.checkAboveSeaLevel(levelAccessor, pos) && Anubis.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

