/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class Banshee
extends AbstractGaiaEntity {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Banshee.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    @Nullable
    private BlockPos boundOrigin;

    public Banshee(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new BansheeMoveControl(this);
        this.f_21364_ = 20;
    }

    public void m_6478_(MoverType moverType, Vec3 pos) {
        super.m_6478_(moverType, pos);
        this.m_20101_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BansheeChargeAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BansheeRandomMoveGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22282_, 0.25).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos pos) {
        this.boundOrigin = pos;
    }

    private boolean getBansheeFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setBansheeFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getBansheeFlag(1);
    }

    public void setIsCharging(boolean charging) {
        this.setBansheeFlag(1, charging);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        Entity entity = source.m_7640_();
        if (entity instanceof Arrow) {
            input += 2.0f;
        }
        if (entity instanceof SpectralArrow) {
            input += 4.0f;
        }
        return super.m_6469_(source, input);
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            entityIn.m_20254_(6);
            return true;
        }
        return false;
    }

    public void m_8119_() {
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
        this.m_20242_(true);
    }

    @Override
    public void m_8107_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_20159_()) {
                this.m_8127_();
            }
            if (this.m_6084_() && this.m_21527_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)11);
                this.m_6469_(this.m_269291_().m_269341_(), this.m_21233_() * 0.25f);
            }
        }
        for (int i = 0; i < 2; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_(), this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), 0.0, 0.0, 0.0);
        }
        super.m_8107_();
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.boundOrigin != null) {
            tag.m_128405_("BoundX", this.boundOrigin.m_123341_());
            tag.m_128405_("BoundY", this.boundOrigin.m_123342_());
            tag.m_128405_("BoundZ", this.boundOrigin.m_123343_());
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("BoundX")) {
            this.boundOrigin = new BlockPos(tag.m_128451_("BoundX"), tag.m_128451_("BoundY"), tag.m_128451_("BoundZ"));
        }
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.BANSHEE.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.BANSHEE.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.BANSHEE.getDeath();
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public int m_5792_() {
        return 1;
    }

    public static boolean checkBansheeSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Banshee.checkDaysPassed(levelAccessor) && Banshee.checkAboveSeaLevel(levelAccessor, pos) && Banshee.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    static class BansheeMoveControl
    extends MoveControl {
        public BansheeMoveControl(Banshee banshee) {
            super((Mob)banshee);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.f_24975_ - this.f_24974_.m_20185_(), this.f_24976_ - this.f_24974_.m_20186_(), this.f_24977_ - this.f_24974_.m_20189_());
                double d0 = vec3.m_82553_();
                if (d0 < this.f_24974_.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82490_(0.5));
                } else {
                    this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82549_(vec3.m_82490_(this.f_24978_ * 0.05 / d0)));
                    if (this.f_24974_.m_5448_() == null) {
                        Vec3 vec31 = this.f_24974_.m_20184_();
                        this.f_24974_.m_146922_(-((float)Mth.m_14136_((double)vec31.f_82479_, (double)vec31.f_82481_)) * 57.295776f);
                        this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
                    } else {
                        double d2 = this.f_24974_.m_5448_().m_20185_() - this.f_24974_.m_20185_();
                        double d1 = this.f_24974_.m_5448_().m_20189_() - this.f_24974_.m_20189_();
                        this.f_24974_.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                        this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
                    }
                }
            }
        }
    }

    static class BansheeChargeAttackGoal
    extends Goal {
        protected final Banshee banshee;

        public BansheeChargeAttackGoal(Banshee banshee) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.banshee = banshee;
        }

        public boolean m_8036_() {
            if (this.banshee.m_5448_() != null && !this.banshee.m_21566_().m_24995_() && this.banshee.m_217043_().m_188503_(BansheeChargeAttackGoal.m_186073_((int)7)) == 0) {
                return this.banshee.m_20280_((Entity)this.banshee.m_5448_()) > 4.0;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.banshee.m_21566_().m_24995_() && this.banshee.isCharging() && this.banshee.m_5448_() != null && this.banshee.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity livingentity = this.banshee.m_5448_();
            if (livingentity != null) {
                Vec3 vec3 = livingentity.m_146892_();
                this.banshee.m_21566_().m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
            }
            this.banshee.setIsCharging(true);
            this.banshee.m_5496_(SoundEvents.f_12500_, 1.0f, 1.0f);
        }

        public void m_8041_() {
            this.banshee.setIsCharging(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.banshee.m_5448_();
            if (livingentity != null) {
                if (this.banshee.m_20191_().m_82381_(livingentity.m_20191_())) {
                    this.banshee.m_7327_((Entity)livingentity);
                    this.banshee.setIsCharging(false);
                } else {
                    double d0 = this.banshee.m_20280_((Entity)livingentity);
                    if (d0 < 9.0) {
                        Vec3 vec3 = livingentity.m_146892_();
                        this.banshee.m_21566_().m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
                    }
                }
            }
        }
    }

    static class BansheeRandomMoveGoal
    extends Goal {
        protected final Banshee banshee;

        public BansheeRandomMoveGoal(Banshee banshee) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.banshee = banshee;
        }

        public boolean m_8036_() {
            return !this.banshee.m_21566_().m_24995_() && this.banshee.m_217043_().m_188503_(BansheeRandomMoveGoal.m_186073_((int)7)) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = this.banshee.getBoundOrigin();
            if (blockpos == null) {
                blockpos = this.banshee.m_20183_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(this.banshee.f_19796_.m_188503_(15) - 7, this.banshee.f_19796_.m_188503_(11) - 5, this.banshee.f_19796_.m_188503_(15) - 7);
                if (!this.banshee.m_9236_().m_46859_(blockpos1)) continue;
                this.banshee.m_21566_().m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 0.25);
                if (this.banshee.m_5448_() != null) break;
                this.banshee.m_21563_().m_24950_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

