/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.entity.Orc;
import gaia.entity.goal.MobAttackGoal;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaLootTables;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class Dwarf
extends AbstractAssistGaiaEntity
implements RangedAttackMob,
IDayMob {
    private static final EntityDataAccessor<Boolean> RANDOM_CLASS = SynchedEntityData.m_135353_(Dwarf.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final RangedBowAttackGoal rangedBowAttackGoal = new RangedBowAttackGoal((Monster)this, 1.275, 20, 15.0f);
    private final MobAttackGoal collideAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.275, true);
    private static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = difficulty -> difficulty == Difficulty.HARD;
    private final BreakDoorGoal breakDoorGoal = new BreakDoorGoal((Mob)this, DOOR_BREAKING_PREDICATE);
    private boolean canBreakDoors;

    public Dwarf(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 20;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        if (((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) {
            this.f_21346_.m_25352_(2, this.targetPlayerGoal);
        }
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Orc.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22277_, 26.0).m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22282_, 0.25).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RANDOM_CLASS, (Object)true);
    }

    public boolean applyRandomClass() {
        return (Boolean)this.f_19804_.m_135370_(RANDOM_CLASS);
    }

    public void setRandomClass(boolean value) {
        this.f_19804_.m_135381_(RANDOM_CLASS, (Object)value);
    }

    @Override
    public int maxVariants() {
        return 2;
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        if (!this.m_21206_().m_41619_() && this.m_21206_().canPerformAction(ToolActions.SHIELD_BLOCK)) {
            return !(source.m_7640_() instanceof AbstractArrow) && super.m_6469_(source, input);
        }
        return super.m_6469_(source, input);
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    effectTime = 10;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    effectTime = 20;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effectTime * 20, 0));
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, effectTime * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (target.m_6084_()) {
            RangedUtil.rangedAttack(target, (LivingEntity)this, distanceFactor);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
    }

    public void m_8061_(EquipmentSlot equipmentSlot, ItemStack stack) {
        super.m_8061_(equipmentSlot, stack);
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    private void setCombatTask() {
        this.f_21345_.m_25363_((Goal)this.collideAttackGoal);
        this.f_21345_.m_25363_((Goal)this.rangedBowAttackGoal);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            this.f_21345_.m_25352_(1, (Goal)this.rangedBowAttackGoal);
        } else {
            this.f_21345_.m_25352_(1, (Goal)this.collideAttackGoal);
        }
    }

    protected ResourceLocation m_7582_() {
        return switch (this.getVariant()) {
            default -> super.m_7582_();
            case 1 -> GaiaLootTables.DWARF_RANGED;
            case 2 -> GaiaLootTables.DWARF_MINER;
        };
    }

    protected void m_213945_(RandomSource random, DifficultyInstance instance) {
        if (this.applyRandomClass()) {
            if (random.m_188503_(4) == 0) {
                ItemStack bowStack = new ItemStack((ItemLike)Items.f_42411_);
                bowStack.m_41663_(Enchantments.f_44989_, 1);
                this.m_8061_(EquipmentSlot.MAINHAND, bowStack);
                if (random.m_188499_() && random.m_188499_()) {
                    if (random.m_188503_(2) == 0) {
                        this.m_8061_(EquipmentSlot.OFFHAND, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)Potions.f_43615_));
                    } else {
                        this.m_8061_(EquipmentSlot.OFFHAND, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)Potions.f_43593_));
                    }
                }
                this.setVariant(1);
            } else if (random.m_188503_(4) == 0) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42427_));
                this.setVariant(2);
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42428_));
                if (random.m_188499_()) {
                    this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.IRON_SHIELD.get()));
                    this.m_21051_(Attributes.f_22278_).m_22100_(0.25);
                }
                this.setVariant(0);
            }
        } else {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42427_));
            this.setVariant(0);
        }
    }

    public boolean canBreakDoors() {
        return this.canBreakDoors;
    }

    public void setCanBreakDoors(boolean p_34337_) {
        if (GoalUtils.m_26894_((Mob)this)) {
            if (this.canBreakDoors != p_34337_) {
                this.canBreakDoors = p_34337_;
                ((GroundPathNavigation)this.m_21573_()).m_26477_(p_34337_);
                if (p_34337_) {
                    this.f_21345_.m_25352_(1, (Goal)this.breakDoorGoal);
                } else {
                    this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
                }
            }
        } else if (this.canBreakDoors) {
            this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
            this.canBreakDoors = false;
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        this.m_213945_(this.f_19796_, difficultyInstance);
        this.m_213945_(this.f_19796_, difficultyInstance);
        this.setCombatTask();
        return data;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("RandomClass", this.applyRandomClass());
        tag.m_128379_("CanBreakDoors", this.canBreakDoors());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("RandomClass")) {
            this.setRandomClass(tag.m_128471_("RandomClass"));
        }
        this.setCanBreakDoors(tag.m_128471_("CanBreakDoors"));
        this.setCombatTask();
    }

    @Override
    public boolean m_6549_(EntityType<?> type) {
        return super.m_6549_(type) && type != GaiaRegistry.DWARF.getEntityType();
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.DWARF.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.DWARF.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.DWARF.getDeath();
    }

    public int m_5792_() {
        return 1;
    }

    public static boolean checkDwarfSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Dwarf.checkDaysPassed(levelAccessor) && Dwarf.checkDaytime(levelAccessor) && Dwarf.checkTagBlocks(levelAccessor, pos, GaiaTags.GAIA_SPAWABLE_ON) && Dwarf.checkAboveSeaLevel(levelAccessor, pos) && Dwarf.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

