/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class NineTails
extends AbstractGaiaEntity
implements RangedAttackMob {
    private static final UUID KNOCKBACK_MODIFIER_UUID = UUID.fromString("E1F5906C-E05C-11EC-9D64-0242AC120002");
    private static final AttributeModifier KNOCKBACK_MODIFIER = new AttributeModifier(KNOCKBACK_MODIFIER_UUID, "Knockback boost", 2.0, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Boolean> THROWING = SynchedEntityData.m_135353_(NineTails.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> WEAPON_TYPE = SynchedEntityData.m_135353_(NineTails.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final RangedAttackGoal bowAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.275, 20, 60, 15.0f);
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.275, true);
    private int switchHealth;
    private boolean animationPlay;
    private int animationTimer;

    public NineTails(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 20;
        this.switchHealth = 0;
        this.animationPlay = false;
        this.animationTimer = 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22277_, 26.0).m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22282_, 0.25).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(THROWING, (Object)false);
        this.f_19804_.m_135372_(WEAPON_TYPE, (Object)0);
    }

    public boolean isThrowing() {
        return (Boolean)this.f_19804_.m_135370_(THROWING);
    }

    public void setThrowing(boolean flag) {
        this.f_19804_.m_135381_(THROWING, (Object)flag);
    }

    public int getWeaponType() {
        return (Integer)this.f_19804_.m_135370_(WEAPON_TYPE);
    }

    public void setWeaponType(int type) {
        this.f_19804_.m_135381_(WEAPON_TYPE, (Object)type);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.m_6469_(source, input);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (target.m_6084_()) {
            RangedUtil.fireball(target, (LivingEntity)this, distanceFactor);
            this.setThrowing(true);
            this.animationPlay = true;
            this.animationTimer = 0;
        }
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            entityIn.m_20254_(6);
            return true;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        if (this.m_21223_() < this.m_21233_() * 0.75f && this.switchHealth == 0) {
            if (this.getWeaponType() == 0) {
                if (this.f_19796_.m_188503_(4) == 0) {
                    this.setWeaponType(2);
                } else {
                    this.setWeaponType(1);
                }
            }
            this.setEnchantedEquipment(this.getWeaponType());
            this.setGoals(1);
            this.switchHealth = 1;
        }
        if (this.m_21223_() > this.m_21233_() * 0.75f && this.switchHealth == 1) {
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            this.setGoals(0);
            this.switchHealth = 0;
        }
        if (this.animationPlay) {
            if (this.animationTimer != 20) {
                ++this.animationTimer;
            } else {
                this.setThrowing(false);
                this.animationPlay = false;
            }
        }
        super.m_8107_();
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.f_21345_.m_25363_((Goal)this.bowAttackGoal);
            this.f_21345_.m_25352_(1, (Goal)this.mobAttackGoal);
        } else {
            this.f_21345_.m_25363_((Goal)this.mobAttackGoal);
            this.f_21345_.m_25352_(1, (Goal)this.bowAttackGoal);
            this.setThrowing(false);
            this.animationPlay = false;
            this.animationTimer = 0;
        }
    }

    private void setCombatTask() {
        if (this.m_21205_().m_41619_() || this.m_21051_(Attributes.f_22282_).m_22109_(KNOCKBACK_MODIFIER)) {
            this.setGoals(0);
        } else {
            this.setGoals(1);
        }
    }

    protected void setEnchantedEquipment(int id) {
        if (id == 1) {
            this.setHandOrKnockback(ItemStack.f_41583_);
        } else if (id == 2) {
            ItemStack weapon = new ItemStack((ItemLike)GaiaRegistry.FAN.get(), 1);
            weapon.m_41663_(Enchantments.f_44980_, 2);
            this.setHandOrKnockback(weapon);
        }
    }

    protected void setHandOrKnockback(ItemStack stack) {
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22282_);
        attributeinstance.m_22130_(KNOCKBACK_MODIFIER);
        if (stack.m_41619_()) {
            attributeinstance.m_22118_(KNOCKBACK_MODIFIER);
        } else {
            this.m_8061_(EquipmentSlot.MAINHAND, stack);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        this.setCombatTask();
        return data;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("WeaponType", this.getWeaponType());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("WeaponType")) {
            int weaponType = tag.m_128451_("WeaponType");
            this.setWeaponType(weaponType);
        }
        this.setCombatTask();
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.NINE_TAILS.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.NINE_TAILS.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.NINE_TAILS.getDeath();
    }

    public boolean m_5825_() {
        return true;
    }

    public int m_5792_() {
        return 1;
    }

    public static boolean checkNineTailsSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return NineTails.checkDaysPassed(levelAccessor) && NineTails.checkAboveSeaLevel(levelAccessor, pos) && NineTails.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

