/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.prop;

import gaia.entity.Mimic;
import gaia.entity.prop.AbstractPropEntity;
import gaia.registry.GaiaLootTables;
import gaia.registry.GaiaRegistry;
import gaia.util.LootHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class Chest
extends AbstractPropEntity {
    private static final EntityDataAccessor<Integer> ROTATION = SynchedEntityData.m_135353_(Chest.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DROP = SynchedEntityData.m_135353_(Chest.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Chest(EntityType<? extends AgeableMob> type, Level level) {
        super(type, level);
        this.f_21364_ = 0;
        this.f_20884_ = 180.0f;
        this.f_20883_ = 180.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 1.0);
    }

    public void m_147240_(double strength, double xRatio, double zRatio) {
    }

    public void m_8107_() {
        if (this.playerDetection() && this.getDrop() == 2) {
            if (!this.m_9236_().f_46443_) {
                this.spawnMimic();
            }
            this.m_146870_();
        }
        super.m_8107_();
    }

    private void spawnMimic() {
        Mimic mimic;
        if (this.m_9236_().m_46791_() != Difficulty.PEACEFUL && (mimic = (Mimic)GaiaRegistry.MIMIC.getEntityType().m_20615_(this.m_9236_())) != null) {
            mimic.m_20035_(this.m_20183_(), 0.0f, 0.0f);
            mimic.m_6518_((ServerLevelAccessor)((ServerLevel)this.m_9236_()), this.m_9236_().m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            this.m_9236_().m_7967_((Entity)mimic);
        }
        this.m_9236_().m_7605_((Entity)this, (byte)6);
    }

    private boolean playerDetection() {
        AABB aabb = new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0).m_82400_(4.0);
        List list = this.m_9236_().m_45976_(Player.class, aabb);
        return !list.isEmpty();
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        this.m_6469_(this.m_269291_().m_269264_(), 2.0f);
        return super.m_6071_(player, hand);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        this.f_20883_ = 180.0f;
        this.f_20884_ = 180.0f;
        this.m_146922_(180.0f);
        this.f_19859_ = 180.0f;
        this.f_20885_ = 180.0f;
        this.f_20886_ = 180.0f;
        RandomSource random = levelAccessor.m_213780_();
        switch (random.m_188503_(4)) {
            case 0: {
                this.setRotation(0);
                break;
            }
            case 1: {
                this.setRotation(1);
                break;
            }
            case 2: {
                this.setRotation(2);
                break;
            }
            case 3: {
                this.setRotation(3);
            }
        }
        if (random.m_188503_(2) == 0) {
            if (random.m_188503_(2) == 0) {
                this.setDrop(2);
            } else {
                this.setDrop(1);
            }
        } else {
            this.setDrop(0);
        }
        return data;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ROTATION, (Object)0);
        this.f_19804_.m_135372_(DROP, (Object)0);
    }

    public int getRotation() {
        return (Integer)this.f_19804_.m_135370_(ROTATION);
    }

    public void setRotation(int rotation) {
        this.f_19804_.m_135381_(ROTATION, (Object)rotation);
    }

    public int getDrop() {
        return (Integer)this.f_19804_.m_135370_(DROP);
    }

    public void setDrop(int drop) {
        this.f_19804_.m_135381_(DROP, (Object)drop);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("rotation", (byte)this.getRotation());
        tag.m_128344_("drop", (byte)this.getDrop());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("rotation")) {
            this.setRotation(tag.m_128445_("rotation"));
        }
        if (tag.m_128441_("drop")) {
            this.setDrop(tag.m_128445_("drop"));
        }
    }

    protected void playParticleEffect(boolean smoke) {
        SimpleParticleType particle = ParticleTypes.f_123762_;
        if (!smoke) {
            particle = ParticleTypes.f_123759_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particle, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
        }
    }

    public void m_7822_(byte id) {
        if (id == 7) {
            this.playParticleEffect(true);
        } else if (id == 6) {
            this.playParticleEffect(false);
        } else {
            super.m_7822_(id);
        }
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11747_;
    }

    protected ResourceLocation m_7582_() {
        if (this.getDrop() == 2) {
            return null;
        }
        if (this.getDrop() == 1) {
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            this.spawnMimic();
            return null;
        }
        return super.m_7582_();
    }

    protected void m_7472_(DamageSource damageSource, int looting, boolean killedByPlayer) {
        if (!this.m_9236_().f_46443_) {
            LootTable loottable = this.m_9236_().m_7654_().m_278653_().m_278676_(GaiaLootTables.CHEST_TABLES);
            LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287289_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)damageSource.m_7640_());
            if (killedByPlayer && this.f_20888_ != null) {
                lootcontext$builder = lootcontext$builder.m_287286_(LootContextParams.f_81456_, (Object)this.f_20888_).m_287239_(this.f_20888_.m_36336_());
            }
            List<ItemStack> stacks = LootHelper.getStacksFromTable((ServerLevel)this.m_9236_(), lootcontext$builder, LootContextParamSets.f_81415_, GaiaLootTables.CHEST_TABLES, 2 + Mth.m_14045_((int)looting, (int)0, (int)2));
            stacks.forEach(arg_0 -> ((Chest)this).m_19983_(arg_0));
        }
        super.m_7472_(damageSource, looting, killedByPlayer);
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return false;
    }

    public int m_5792_() {
        return 1;
    }

    public int m_8132_() {
        return 180;
    }

    public int m_8085_() {
        return 180;
    }

    public void m_7334_(Entity entity) {
    }

    public boolean m_5829_() {
        return false;
    }

    public float m_6143_() {
        return 0.0f;
    }

    public static boolean checkChestSpawnRules(EntityType<? extends AgeableMob> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Chest.checkDaysPassed(levelAccessor) && Chest.checkBelowSeaLevel(levelAccessor, pos) && Chest.checkPropSpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

