/*
 * Decompiled with CFR 0.152.
 */
package gaia.item.accessory;

import gaia.compat.curios.CuriosCompat;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAccessoryItem
extends Item {
    public AbstractAccessoryItem(Item.Properties properties) {
        super(properties.m_41497_(Rarity.RARE));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, level, list, flag);
    }

    public boolean m_5812_(ItemStack stack) {
        return ModList.get().isLoaded("curios");
    }

    public boolean isModifier() {
        return false;
    }

    public abstract void doEffect(LivingEntity var1, ItemStack var2);

    public abstract void applyModifier(LivingEntity var1, ItemStack var2);

    public abstract void removeModifier(LivingEntity var1, ItemStack var2);

    public void onEquip(LivingEntity livingEntity, ItemStack stack) {
        if (this.isModifier()) {
            this.applyModifier(livingEntity, stack);
        }
    }

    public void onUnequip(LivingEntity livingEntity, ItemStack stack) {
        if (this.isModifier()) {
            this.removeModifier(livingEntity, stack);
        }
    }

    public void onTick(LivingEntity livingEntity, ItemStack stack) {
        this.doEffect(livingEntity, stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.getCapability(stack);
        }
        return super.initCapabilities(stack, nbt);
    }
}

