/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus.datagen.datapack;

import com.coolerpromc.arrowplus.datacomponent.ModDataComponents;
import com.coolerpromc.arrowplus.item.ModItems;
import com.coolerpromc.arrowplus.registry.ModRegistries;
import com.coolerpromc.arrowplus.util.ArrowData;
import com.coolerpromc.arrowplus.util.ModRecipeSerializer;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ArrowRecipe
extends CustomRecipe {
    public ArrowRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        if (craftingInput.width() == 1 && craftingInput.height() == 3 && craftingInput.ingredientCount() == 3) {
            Registry registry = level.registryAccess().lookupOrThrow(ModRegistries.ARROW_DATA_KEY);
            ArrayList<Either<ResourceLocation, TagKey<Item>>> materialList = new ArrayList<Either<ResourceLocation, TagKey<Item>>>();
            for (ArrowData data : registry) {
                materialList.add(data.material());
            }
            boolean hasMaterial = false;
            boolean hasStick = false;
            boolean hasFeather = false;
            ItemStack materialStack = craftingInput.getItem(0);
            for (Either either : materialList) {
                if (either.left().isPresent() && ((ResourceLocation)either.left().get()).equals((Object)BuiltInRegistries.ITEM.getKey((Object)materialStack.getItem()))) {
                    hasMaterial = true;
                    break;
                }
                if (!either.right().isPresent() || !materialStack.is((TagKey)either.right().get())) continue;
                hasMaterial = true;
                break;
            }
            if (craftingInput.getItem(1).is(Items.STICK)) {
                hasStick = true;
            }
            if (craftingInput.getItem(2).is(Items.FEATHER)) {
                hasFeather = true;
            }
            return hasMaterial && hasStick && hasFeather;
        }
        return false;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        ArrayList materialList = new ArrayList();
        AtomicReference<ArrowData> arrowData = new AtomicReference<ArrowData>(ArrowData.EMPTY);
        ItemStack materialStack = craftingInput.getItem(0);
        provider.lookupOrThrow(ModRegistries.ARROW_DATA_KEY).listElements().forEach(holder -> {
            materialList.add(((ArrowData)holder.value()).material());
            if (((ArrowData)holder.value()).material().left().isPresent() && ((ResourceLocation)((ArrowData)holder.value()).material().left().get()).equals((Object)BuiltInRegistries.ITEM.getKey((Object)materialStack.getItem()))) {
                arrowData.set((ArrowData)holder.value());
            } else if (((ArrowData)holder.value()).material().right().isPresent() && materialStack.is((TagKey)((ArrowData)holder.value()).material().right().get())) {
                arrowData.set((ArrowData)holder.value());
            }
        });
        if (materialList.contains(arrowData.get().material())) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.ARROW_PLUS.get(), 4);
            stack.set((DataComponentType)ModDataComponents.ARROW_DATA.get(), (Object)arrowData.get());
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializer.ARROW_RECIPE_SERIALIZER.get();
    }
}

