/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus.entity.custom;

import com.coolerpromc.arrowplus.datacomponent.ModDataComponents;
import com.coolerpromc.arrowplus.util.ArrowData;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModArrowEntity
extends AbstractArrow {
    private final ItemStack stack;
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(ModArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ModArrowEntity(EntityType<? extends AbstractArrow> p_331098_, Level p_331626_, ItemStack pickupItemStack) {
        super(p_331098_, p_331626_);
        this.stack = pickupItemStack;
        this.updateColor();
    }

    public ModArrowEntity(EntityType<? extends AbstractArrow> entityType, LivingEntity owner, Level level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon, double baseDamage) {
        super(entityType, owner, level, pickupItemStack.copyWithCount(1), firedFromWeapon);
        this.stack = pickupItemStack;
        this.pickup = AbstractArrow.Pickup.ALLOWED;
        if (firedFromWeapon != null && firedFromWeapon.getItem() instanceof BowItem) {
            int infinityLevel;
            int powerLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().getOrThrow(Enchantments.POWER), (ItemStack)firedFromWeapon);
            if (powerLevel > 0) {
                baseDamage += baseDamage * 0.25 * (double)(powerLevel + 1);
            }
            this.pickup = (infinityLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().getOrThrow(Enchantments.INFINITY), (ItemStack)firedFromWeapon)) > 0 ? AbstractArrow.Pickup.DISALLOWED : AbstractArrow.Pickup.ALLOWED;
        }
        this.setBaseDamage(baseDamage);
        this.updateColor();
    }

    public ModArrowEntity(EntityType<? extends AbstractArrow> entityType, double x, double y, double z, Level level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(entityType, x, y, z, level, pickupItemStack, firedFromWeapon);
        this.stack = pickupItemStack;
        this.updateColor();
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return this.stack;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR, (Object)-1);
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putInt("color", this.getColor());
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.entityData.set(COLOR, (Object)valueInput.getIntOr("color", -1));
    }

    public void updateColor() {
        this.entityData.set(COLOR, (Object)((ArrowData)this.stack.getOrDefault((DataComponentType)ModDataComponents.ARROW_DATA.get(), (Object)ArrowData.EMPTY)).color());
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }
}

