/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus.item.custom;

import com.coolerpromc.arrowplus.datacomponent.ModDataComponents;
import com.coolerpromc.arrowplus.entity.custom.ModArrowEntity;
import com.coolerpromc.arrowplus.util.ArrowData;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ModArrowItem
extends ArrowItem {
    private final EntityType<? extends AbstractArrow> entityType;

    public ModArrowItem(Item.Properties p_40512_, EntityType<? extends AbstractArrow> entityType) {
        super(p_40512_);
        this.entityType = entityType;
    }

    public AbstractArrow createArrow(Level level, ItemStack ammo, LivingEntity shooter, @Nullable ItemStack weapon) {
        return new ModArrowEntity(this.entityType, shooter, level, ammo.copyWithCount(1), weapon, ((ArrowData)ammo.getOrDefault(ModDataComponents.ARROW_DATA, (Object)ArrowData.EMPTY)).baseDamage());
    }

    public boolean isInfinite(ItemStack ammo, ItemStack bow, LivingEntity livingEntity) {
        return bow.getEnchantmentLevel((Holder)livingEntity.level().registryAccess().getOrThrow(Enchantments.INFINITY)) > 0;
    }

    public Projectile asProjectile(Level level, Position location, ItemStack stack, Direction p_338469_) {
        ModArrowEntity arrow = new ModArrowEntity(this.entityType, location.x(), location.y(), location.z(), level, stack.copyWithCount(1), null);
        arrow.setBaseDamage(((ArrowData)stack.getOrDefault(ModDataComponents.ARROW_DATA, (Object)ArrowData.EMPTY)).baseDamage());
        arrow.pickup = AbstractArrow.Pickup.ALLOWED;
        return arrow;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        tooltipAdder.accept((Component)Component.translatable((String)"tooltip.arrowplus.base_damage", (Object[])new Object[]{((ArrowData)stack.getOrDefault(ModDataComponents.ARROW_DATA, (Object)ArrowData.EMPTY)).baseDamage()}).withColor(0xBBBBBB));
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)((ArrowData)stack.getOrDefault(ModDataComponents.ARROW_DATA, (Object)ArrowData.EMPTY)).translationKey());
    }
}

