/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus.compat.jei;

import com.coolerpromc.arrowplus.compat.jei.ArrowSubtypeInterpreter;
import com.coolerpromc.arrowplus.datacomponent.ModDataComponents;
import com.coolerpromc.arrowplus.item.ModItems;
import com.coolerpromc.arrowplus.registry.ModRegistries;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class ModJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"arrowplus", (String)"jei_plugin");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IVanillaRecipeFactory vanillaRecipeFactory = registration.getJeiHelpers().getVanillaRecipeFactory();
        String group = "arrowplus.arrow";
        List<RecipeHolder> arrowRecipes = RegistryUtil.getRegistry(ModRegistries.ARROW_DATA_KEY).stream().map(data -> {
            Ingredient ingredient = Ingredient.of((ItemLike[])new ItemLike[]{Items.FLINT});
            ResourceLocation materialLocation = ResourceLocation.parse((String)"invalid");
            ItemStack output = new ItemStack((ItemLike)ModItems.ARROW_PLUS.get(), 4);
            output.set(ModDataComponents.ARROW_DATA, data);
            if (data.material().left().isPresent()) {
                ingredient = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get((ResourceLocation)data.material().left().get())});
                materialLocation = (ResourceLocation)data.material().left().get();
            } else if (data.material().right().isPresent()) {
                ingredient = Ingredient.of((TagKey)((TagKey)data.material().right().get()));
                materialLocation = ((TagKey)data.material().right().get()).location();
            }
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arrowplus", (String)("arrowplus.arrow." + materialLocation.getPath()));
            CraftingRecipe recipe = vanillaRecipeFactory.createShapedRecipeBuilder(CraftingBookCategory.MISC, List.of(output)).group(group).define(Character.valueOf('m'), ingredient).define(Character.valueOf('s'), Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK})).define(Character.valueOf('f'), Ingredient.of((ItemLike[])new ItemLike[]{Items.FEATHER})).pattern(" m ").pattern(" s ").pattern(" f ").build();
            return new RecipeHolder(id, (Recipe)recipe);
        }).toList();
        registration.addRecipes(RecipeTypes.CRAFTING, arrowRecipes);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.ARROW_PLUS.get(), (ISubtypeInterpreter)ArrowSubtypeInterpreter.INSTANCE);
    }
}

