/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus.entity.custom;

import com.coolerpromc.arrowplus.datacomponent.ModDataComponents;
import com.coolerpromc.arrowplus.entity.ModEntities;
import com.coolerpromc.arrowplus.util.ArrowData;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModArrowEntity
extends AbstractArrow {
    private final ItemStack stack;
    private static final EntityDataAccessor<ArrowData> ARROW_DATA = SynchedEntityData.defineId(ModArrowEntity.class, ModEntities.ARROW_DATA.get());

    public ModArrowEntity(EntityType<? extends AbstractArrow> p_331098_, Level p_331626_, ItemStack pickupItemStack) {
        super(p_331098_, p_331626_);
        this.stack = pickupItemStack;
        this.updateArrowData();
    }

    public ModArrowEntity(EntityType<? extends AbstractArrow> entityType, LivingEntity owner, Level level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon, double baseDamage) {
        super(entityType, owner, level, pickupItemStack.copyWithCount(1), firedFromWeapon);
        this.stack = pickupItemStack;
        this.pickup = AbstractArrow.Pickup.ALLOWED;
        if (firedFromWeapon != null && firedFromWeapon.getItem() instanceof BowItem) {
            int infinityLevel;
            int powerLevel = firedFromWeapon.getEnchantmentLevel(level.registryAccess().holderOrThrow(Enchantments.POWER));
            if (powerLevel > 0) {
                baseDamage += baseDamage * 0.25 * (double)(powerLevel + 1);
            }
            this.pickup = (infinityLevel = firedFromWeapon.getEnchantmentLevel(level.registryAccess().holderOrThrow(Enchantments.INFINITY))) > 0 ? AbstractArrow.Pickup.DISALLOWED : AbstractArrow.Pickup.ALLOWED;
        }
        this.setBaseDamage(baseDamage);
        this.updateArrowData();
    }

    public ModArrowEntity(EntityType<? extends AbstractArrow> entityType, double x, double y, double z, Level level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(entityType, x, y, z, level, pickupItemStack, firedFromWeapon);
        this.stack = pickupItemStack;
        this.updateArrowData();
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return this.stack;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ARROW_DATA, (Object)ArrowData.EMPTY);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("arrow_data", (Tag)ArrowData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getArrowData()).getOrThrow());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(ARROW_DATA, (Object)((ArrowData)ArrowData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("arrow_data")).getOrThrow()));
    }

    public void updateArrowData() {
        this.entityData.set(ARROW_DATA, (Object)((ArrowData)this.stack.getOrDefault(ModDataComponents.ARROW_DATA, (Object)ArrowData.EMPTY)));
    }

    public ArrowData getArrowData() {
        return (ArrowData)this.entityData.get(ARROW_DATA);
    }

    public Component getName() {
        return Component.translatable((String)this.getArrowData().translationKey());
    }

    protected double getDefaultGravity() {
        return this.getArrowData().gravity();
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        this.getArrowData().effects().forEach((resourceLocation, integer) -> BuiltInRegistries.POTION.getOptional(resourceLocation).ifPresent(potionReference -> potionReference.getEffects().forEach(instance -> entity.addEffect(new MobEffectInstance(instance.getEffect(), integer.intValue(), instance.getAmplifier(), instance.isAmbient(), instance.isVisible(), instance.showIcon(), null)))));
    }

    public boolean isOnFire() {
        return this.getArrowData().flame();
    }
}

