/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus.entity.renderer;

import com.coolerpromc.arrowplus.entity.custom.ModArrowEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.projectile.AbstractArrow;

public class ModArrowRenderer
extends ArrowRenderer<ModArrowEntity> {
    public final ResourceLocation arrowTexture;
    public static final ResourceLocation BODY_TEXTURE = ModArrowRenderer.getTextureLocation("arrow_plus");
    public static final ResourceLocation HEAD_TEXTURE = ModArrowRenderer.getTextureLocation("arrow_plus_head");

    public ModArrowRenderer(EntityRendererProvider.Context context, ResourceLocation arrowTexture) {
        super(context);
        this.arrowTexture = arrowTexture;
    }

    public static ResourceLocation getTextureLocation(String textureName) {
        return ResourceLocation.fromNamespaceAndPath((String)"arrowplus", (String)("textures/entity/projectiles/" + textureName + ".png"));
    }

    public void render(ModArrowEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot())));
        float f9 = (float)entity.shakeTime - partialTicks;
        if (f9 > 0.0f) {
            float f10 = -Mth.sin((float)(f9 * 3.0f)) * f9;
            poseStack.mulPose(Axis.ZP.rotationDegrees(f10));
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(45.0f));
        poseStack.scale(0.05625f, 0.05625f, 0.05625f);
        poseStack.translate(-4.0f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)HEAD_TEXTURE));
        PoseStack.Pose posestack$pose = poseStack.last();
        this.setVertex(posestack$pose, vertexconsumer, -7, -2, -2, 0.0f, 0.15625f, -1, 0, 0, packedLight, entity.getArrowData().color());
        this.setVertex(posestack$pose, vertexconsumer, -7, -2, 2, 0.15625f, 0.15625f, -1, 0, 0, packedLight, entity.getArrowData().color());
        this.setVertex(posestack$pose, vertexconsumer, -7, 2, 2, 0.15625f, 0.3125f, -1, 0, 0, packedLight, entity.getArrowData().color());
        this.setVertex(posestack$pose, vertexconsumer, -7, 2, -2, 0.0f, 0.3125f, -1, 0, 0, packedLight, entity.getArrowData().color());
        this.setVertex(posestack$pose, vertexconsumer, -7, 2, -2, 0.0f, 0.15625f, 1, 0, 0, packedLight, entity.getArrowData().color());
        this.setVertex(posestack$pose, vertexconsumer, -7, 2, 2, 0.15625f, 0.15625f, 1, 0, 0, packedLight, entity.getArrowData().color());
        this.setVertex(posestack$pose, vertexconsumer, -7, -2, 2, 0.15625f, 0.3125f, 1, 0, 0, packedLight, entity.getArrowData().color());
        this.setVertex(posestack$pose, vertexconsumer, -7, -2, -2, 0.0f, 0.3125f, 1, 0, 0, packedLight, entity.getArrowData().color());
        for (int j = 0; j < 4; ++j) {
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.setVertex(posestack$pose, vertexconsumer, -8, -2, 0, 0.0f, 0.0f, 0, 1, 0, packedLight, entity.getArrowData().color());
            this.setVertex(posestack$pose, vertexconsumer, 8, -2, 0, 0.5f, 0.0f, 0, 1, 0, packedLight, entity.getArrowData().color());
            this.setVertex(posestack$pose, vertexconsumer, 8, 2, 0, 0.5f, 0.15625f, 0, 1, 0, packedLight, entity.getArrowData().color());
            this.setVertex(posestack$pose, vertexconsumer, -8, 2, 0, 0.0f, 0.15625f, 0, 1, 0, packedLight, entity.getArrowData().color());
        }
        poseStack.popPose();
        super.render((AbstractArrow)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public void setVertex(PoseStack.Pose pose, VertexConsumer consumer, int x, int y, int z, float u, float v, int normalX, int normalY, int normalZ, int packedLight, int color) {
        consumer.addVertex(pose, (float)x, (float)y, (float)z).setColor(color).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, (float)normalX, (float)normalZ, (float)normalY);
    }

    public ResourceLocation getTextureLocation(ModArrowEntity arrowEntity) {
        return BODY_TEXTURE;
    }
}

