/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus.util;

import com.coolerpromc.arrowplus.util.ExtraStreamCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public record ArrowData(Either<ResourceLocation, TagKey<Item>> material, double baseDamage, int color, String translationKey, boolean flame, double gravity, Map<ResourceLocation, Integer> effects) {
    public static final Codec<Either<ResourceLocation, TagKey<Item>>> MATERIAL_CODEC = Codec.either((Codec)ResourceLocation.CODEC, (Codec)TagKey.hashedCodec((ResourceKey)Registries.ITEM));
    public static final StreamCodec<ByteBuf, Either<ResourceLocation, TagKey<Item>>> MATERIAL_STREAM_CODEC = ByteBufCodecs.either((StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)ResourceLocation.STREAM_CODEC.map(p_372701_ -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)p_372701_), TagKey::location));
    public static final Codec<ArrowData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MATERIAL_CODEC.fieldOf("material").forGetter(ArrowData::material), (App)Codec.DOUBLE.fieldOf("baseDamage").forGetter(ArrowData::baseDamage), (App)Codec.INT.fieldOf("color").forGetter(ArrowData::color), (App)Codec.STRING.fieldOf("translationKey").forGetter(ArrowData::translationKey), (App)Codec.BOOL.fieldOf("flame").forGetter(ArrowData::flame), (App)Codec.DOUBLE.fieldOf("gravity").forGetter(ArrowData::gravity), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.INT).fieldOf("effects").forGetter(ArrowData::effects)).apply((Applicative)instance, ArrowData::new));
    public static final StreamCodec<FriendlyByteBuf, ArrowData> STREAM_CODEC = ExtraStreamCodecs.composite(MATERIAL_STREAM_CODEC, ArrowData::material, ByteBufCodecs.DOUBLE, ArrowData::baseDamage, ByteBufCodecs.INT, ArrowData::color, ByteBufCodecs.STRING_UTF8, ArrowData::translationKey, ByteBufCodecs.BOOL, ArrowData::flame, ByteBufCodecs.DOUBLE, ArrowData::gravity, ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)ByteBufCodecs.INT), ArrowData::effects, ArrowData::new);
    public static final ArrowData EMPTY = new ArrowData(Items.AIR, 0.0, -15461356, "item.arrowplus.cheated_item", false, 0.05, Map.of());

    public ArrowData(Item material, double baseDamage, int color, String translationKey, boolean flame, double gravity, Map<ResourceLocation, Integer> effects) {
        this((Either<ResourceLocation, TagKey<Item>>)Either.left((Object)BuiltInRegistries.ITEM.getKey((Object)material)), baseDamage, color, translationKey, flame, gravity, effects);
    }

    public ArrowData(TagKey<Item> material, double baseDamage, int color, String translationKey, boolean flame, double gravity, Map<ResourceLocation, Integer> effects) {
        this((Either<ResourceLocation, TagKey<Item>>)Either.right(material), baseDamage, color, translationKey, flame, gravity, effects);
    }
}

