/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus.datagen.datapack;

import com.coolerpromc.arrowplus.config.ArrowPlusConfig;
import com.coolerpromc.arrowplus.item.ModItems;
import com.coolerpromc.arrowplus.registry.ModRegistries;
import com.coolerpromc.arrowplus.util.ArrowData;
import com.coolerpromc.arrowplus.util.ModRecipeSerializer;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ArrowRecipe
extends CustomRecipe {
    public ArrowRecipe(ResourceLocation resourceLocation, CraftingBookCategory category) {
        super(resourceLocation, category);
    }

    public boolean matches(CraftingContainer craftingInput, Level level) {
        if (craftingInput.m_39347_() == 3 && craftingInput.m_39346_() == 3) {
            ArrayList materialList = new ArrayList();
            level.m_9598_().m_255025_(ModRegistries.ARROW_DATA_KEY).m_214062_().filter(reference -> !ArrowPlusConfig.CONFIG.getRemoval().contains(reference.m_205785_().m_135782_().m_135815_())).forEach(reference -> {
                ArrowData arrowData = (ArrowData)reference.m_203334_();
                materialList.add(arrowData.material());
            });
            boolean hasMaterial = false;
            boolean hasStick = false;
            boolean hasFeather = false;
            List<ItemStack> row1 = List.of(craftingInput.m_8020_(0), craftingInput.m_8020_(1), craftingInput.m_8020_(2));
            if (row1.stream().filter(itemStack -> !itemStack.m_150930_(Items.f_41852_)).count() != 1L) {
                return false;
            }
            int column = 0;
            for (ItemStack itemStack2 : row1) {
                if (!itemStack2.m_150930_(Items.f_41852_)) break;
                ++column;
            }
            ItemStack materialStack = row1.get(column);
            for (Either material : materialList) {
                if (material.left().isPresent() && ((ResourceLocation)material.left().get()).equals((Object)BuiltInRegistries.f_257033_.m_7981_((Object)materialStack.m_41720_()))) {
                    hasMaterial = true;
                    break;
                }
                if (!material.right().isPresent() || !materialStack.m_204117_((TagKey)material.right().get())) continue;
                hasMaterial = true;
                break;
            }
            if (craftingInput.m_8020_(column + 3).m_150930_(Items.f_42398_)) {
                hasStick = true;
            }
            if (craftingInput.m_8020_(column + 6).m_150930_(Items.f_42402_)) {
                hasFeather = true;
            }
            return hasMaterial && hasStick && hasFeather;
        }
        return false;
    }

    public ItemStack assemble(CraftingContainer craftingInput, RegistryAccess provider) {
        ArrayList materialList = new ArrayList();
        AtomicReference<ArrowData> arrowData = new AtomicReference<ArrowData>(ArrowData.EMPTY);
        List<ItemStack> row1 = List.of(craftingInput.m_8020_(0), craftingInput.m_8020_(1), craftingInput.m_8020_(2));
        if (row1.stream().filter(itemStack -> !itemStack.m_150930_(Items.f_41852_)).count() != 1L) {
            return ItemStack.f_41583_;
        }
        int column = 0;
        for (ItemStack itemStack2 : row1) {
            if (!itemStack2.m_150930_(Items.f_41852_)) break;
            ++column;
        }
        ItemStack materialStack = row1.get(column);
        provider.m_255025_(ModRegistries.ARROW_DATA_KEY).m_214062_().forEach(holder -> {
            materialList.add(((ArrowData)holder.m_203334_()).material());
            if (((ArrowData)holder.m_203334_()).material().left().isPresent() && ((ResourceLocation)((ArrowData)holder.m_203334_()).material().left().get()).equals((Object)BuiltInRegistries.f_257033_.m_7981_((Object)materialStack.m_41720_()))) {
                arrowData.set((ArrowData)holder.m_203334_());
            } else if (((ArrowData)holder.m_203334_()).material().right().isPresent() && materialStack.m_204117_((TagKey)((ArrowData)holder.m_203334_()).material().right().get())) {
                arrowData.set((ArrowData)holder.m_203334_());
            }
        });
        if (materialList.contains(arrowData.get().material())) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.ARROW_PLUS.get(), 4);
            arrowData.get().save(stack.m_41784_(), provider);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 1 && height >= 3;
    }

    public RecipeSerializer<? extends CustomRecipe> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializer.ARROW_RECIPE_SERIALIZER.get();
    }
}

