/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public record ArrowData(Either<class_2960, class_6862<class_1792>> material, double baseDamage, int color, String translationKey, boolean flame, double gravity, Map<class_2960, Integer> effects) {
    public static final Codec<Either<class_2960, class_6862<class_1792>>> MATERIAL_CODEC = Codec.either((Codec)class_2960.field_25139, (Codec)class_6862.method_40093((class_5321)class_7924.field_41197));
    public static final Codec<ArrowData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MATERIAL_CODEC.fieldOf("material").forGetter(ArrowData::material), (App)Codec.DOUBLE.fieldOf("baseDamage").forGetter(ArrowData::baseDamage), (App)Codec.INT.fieldOf("color").forGetter(ArrowData::color), (App)Codec.STRING.fieldOf("translationKey").forGetter(ArrowData::translationKey), (App)Codec.BOOL.fieldOf("flame").forGetter(ArrowData::flame), (App)Codec.DOUBLE.fieldOf("gravity").forGetter(ArrowData::gravity), (App)Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)Codec.INT).fieldOf("effects").forGetter(ArrowData::effects)).apply((Applicative)instance, ArrowData::new));
    public static final ArrowData EMPTY = new ArrowData(class_1802.field_8162, 0.0, -15461356, "item.arrowplus.cheated_item", false, 0.05, Map.of());

    public ArrowData(class_1792 material, double baseDamage, int color, String translationKey, boolean flame, double gravity, Map<class_2960, Integer> effects) {
        this((Either<class_2960, class_6862<class_1792>>)Either.left((Object)class_7923.field_41178.method_10221((Object)material)), baseDamage, color, translationKey, flame, gravity, effects);
    }

    public ArrowData(class_6862<class_1792> material, double baseDamage, int color, String translationKey, boolean flame, double gravity, Map<class_2960, Integer> effects) {
        this((Either<class_2960, class_6862<class_1792>>)Either.right(material), baseDamage, color, translationKey, flame, gravity, effects);
    }

    public class_2487 save(class_2487 existingTag) {
        existingTag.method_10566("arrow_data", (class_2520)CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this).getOrThrow(false, System.err::println));
        return existingTag;
    }

    public static ArrowData load(class_2487 tag) {
        if (!tag.method_10573("arrow_data", 10)) {
            return EMPTY;
        }
        return (ArrowData)CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("arrow_data")).getOrThrow(false, System.err::println);
    }

    public static void encode(class_2540 buf, ArrowData data) {
        ArrowData.writeMaterial(buf, data.material);
        buf.writeDouble(data.baseDamage);
        buf.writeInt(data.color);
        buf.method_10814(data.translationKey);
        buf.writeBoolean(data.flame);
        buf.writeDouble(data.gravity);
        buf.method_34063(data.effects, class_2540::method_10812, class_2540::writeInt);
    }

    public static ArrowData decode(class_2540 buf) {
        return new ArrowData(ArrowData.readMaterial(buf), buf.readDouble(), buf.readInt(), buf.method_19772(), buf.readBoolean(), buf.readDouble(), (Map<class_2960, Integer>)buf.method_34067(class_2540::method_10810, class_2540::readInt));
    }

    public static void writeMaterial(class_2540 buf, Either<class_2960, class_6862<class_1792>> material) {
        buf.writeBoolean(material.left().isPresent());
        material.ifLeft(arg_0 -> ((class_2540)buf).method_10812(arg_0));
        material.ifRight(tag -> buf.method_10812(tag.comp_327()));
    }

    public static Either<class_2960, class_6862<class_1792>> readMaterial(class_2540 buf) {
        boolean isLeft = buf.readBoolean();
        if (isLeft) {
            return Either.left((Object)buf.method_10810());
        }
        return Either.right((Object)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)buf.method_10810()));
    }
}

