/*
 * Decompiled with CFR 0.152.
 */
package com.notjang.rosen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.notjang.rosen.Constants;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class CustomInstrumentLoader
extends SimpleJsonResourceReloadListener {
    public static final HashMap<String, SoundEvent> customInstruments = new HashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final CustomInstrumentLoader INSTANCE = new CustomInstrumentLoader();

    public CustomInstrumentLoader() {
        super(GSON, "noteblock_instrument");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> jsons, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        customInstruments.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            ResourceLocation id = entry.getKey();
            JsonElement element = entry.getValue();
            try {
                JsonObject json = element.getAsJsonObject();
                String name = GsonHelper.getAsString((JsonObject)json, (String)"name");
                String soundEventId = GsonHelper.getAsString((JsonObject)json, (String)"sound_event");
                ResourceLocation soundLocation = ResourceLocation.parse((String)soundEventId);
                SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(soundLocation);
                if (soundEvent == null) {
                    soundEvent = SoundEvent.createVariableRangeEvent((ResourceLocation)soundLocation);
                }
                customInstruments.put(name, soundEvent);
                Constants.LOG.info("Loaded custom noteblock instrument '{}' -> {}", (Object)name, (Object)soundEventId);
            }
            catch (Exception e) {
                Constants.LOG.error("Failed to load custom noteblock instrument from {}: {}", (Object)id, (Object)e.toString());
            }
        }
        if (!customInstruments.isEmpty()) {
            Constants.LOG.info("Loaded {} custom noteblock instruments", (Object)customInstruments.size());
        }
    }
}

