/*
 * Decompiled with CFR 0.152.
 */
package com.notjang.rosen.mixin;

import com.notjang.rosen.CustomInstrumentLoader;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public class BlockStateBaseMixin {
    @Inject(method={"instrument()Lnet/minecraft/world/level/block/state/properties/NoteBlockInstrument;"}, at={@At(value="RETURN")}, cancellable=true)
    private void instrument(CallbackInfoReturnable<NoteBlockInstrument> cir) {
        NoteBlockInstrument currentInstrument = (NoteBlockInstrument)cir.getReturnValue();
        NoteBlockInstrument custom = null;
        for (NoteBlockInstrument instrument : NoteBlockInstrument.values()) {
            String name = instrument.getSerializedName();
            if (name.equals("custom")) {
                custom = instrument;
                continue;
            }
            if (!this.rosen$isBlockInTag(name + "_noteblocks")) continue;
            currentInstrument = instrument;
            break;
        }
        for (String customInstrument : CustomInstrumentLoader.customInstruments.keySet()) {
            if (!this.rosen$isBlockInTag(customInstrument + "_noteblocks")) continue;
            currentInstrument = custom;
            break;
        }
        cir.setReturnValue((Object)currentInstrument);
    }

    @Unique
    private boolean rosen$isBlockInTag(String tagName) {
        TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"rosen", (String)tagName));
        BlockBehaviour.BlockStateBase thisObject = (BlockBehaviour.BlockStateBase)this;
        return thisObject.is(tag);
    }
}

