/*
 * Decompiled with CFR 0.152.
 */
package com.notjang.rosen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.notjang.rosen.Constants;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class CustomInstrumentLoader
extends class_4309 {
    public static final HashMap<String, class_3414> customInstruments = new HashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final CustomInstrumentLoader INSTANCE = new CustomInstrumentLoader();

    public CustomInstrumentLoader() {
        super(GSON, "noteblock_instrument");
    }

    protected void apply(@NotNull Map<class_2960, JsonElement> jsons, @NotNull class_3300 manager, @NotNull class_3695 profiler) {
        customInstruments.clear();
        for (Map.Entry<class_2960, JsonElement> entry : jsons.entrySet()) {
            class_2960 id = entry.getKey();
            JsonElement element = entry.getValue();
            try {
                JsonObject json = element.getAsJsonObject();
                String name = class_3518.method_15265((JsonObject)json, (String)"name");
                String soundEventId = class_3518.method_15265((JsonObject)json, (String)"sound_event");
                class_2960 soundLocation = class_2960.method_60654((String)soundEventId);
                class_3414 soundEvent = (class_3414)class_7923.field_41172.method_10223(soundLocation);
                if (soundEvent == null) {
                    soundEvent = class_3414.method_47908((class_2960)soundLocation);
                }
                customInstruments.put(name, soundEvent);
                Constants.LOG.info("Loaded custom noteblock instrument '{}' -> {}", (Object)name, (Object)soundEventId);
            }
            catch (Exception e) {
                Constants.LOG.error("Failed to load custom noteblock instrument from {}: {}", (Object)id, (Object)e.toString());
            }
        }
        if (!customInstruments.isEmpty()) {
            Constants.LOG.info("Loaded {} custom noteblock instruments", (Object)customInstruments.size());
        }
    }
}

