/*
 * Decompiled with CFR 0.152.
 */
package fr.ultralion.veinmining.event;

import fr.ultralion.veinmining.ModEnchantments;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class BlockBreakHandler {
    private static final int MAX_BLOCKS = 64;
    private static final int SEARCH_RANGE = 1;

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack tool = player2.getMainHandItem();
        int enchantmentLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)serverLevel.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(ModEnchantments.VEINMINING), (ItemStack)tool);
        if (enchantmentLevel <= 0) {
            return;
        }
        BlockState brokenBlock = event.getState();
        String blockName = brokenBlock.getBlock().toString().toLowerCase();
        if (!blockName.contains("ore")) {
            return;
        }
        this.veinMine(serverLevel, player2, event.getPos(), brokenBlock, tool, enchantmentLevel);
    }

    private void veinMine(ServerLevel level, ServerPlayer player, BlockPos startPos, BlockState targetBlock, ItemStack tool, int enchantmentLevel) {
        Block targetBlockType = targetBlock.getBlock();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        toCheck.add(startPos);
        visited.add(startPos);
        int blocksDestroyed = 0;
        int maxBlocks = 64 * enchantmentLevel;
        block0: while (!toCheck.isEmpty() && blocksDestroyed < maxBlocks) {
            BlockPos currentPos = (BlockPos)toCheck.poll();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos neighborPos;
                        if (x == 0 && y == 0 && z == 0 || visited.contains(neighborPos = currentPos.offset(x, y, z))) continue;
                        visited.add(neighborPos);
                        BlockState neighborState = level.getBlockState(neighborPos);
                        if (neighborState.getBlock() != targetBlockType) continue;
                        toCheck.add(neighborPos);
                        if (this.breakBlock(level, player, neighborPos, neighborState, tool)) {
                            ++blocksDestroyed;
                        }
                        if (blocksDestroyed >= maxBlocks) break;
                    }
                    if (blocksDestroyed >= maxBlocks) break;
                }
                if (blocksDestroyed >= maxBlocks) continue block0;
            }
        }
    }

    private boolean breakBlock(ServerLevel level, ServerPlayer player, BlockPos pos, BlockState state, ItemStack tool) {
        if (!tool.isCorrectToolForDrops(state)) {
            return false;
        }
        boolean broken = level.destroyBlock(pos, false, (Entity)player);
        if (broken) {
            Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), (Entity)player, (ItemStack)tool);
            tool.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            int exp = state.getBlock().getExpDrop(state, (LevelAccessor)level, pos, level.getBlockEntity(pos), (Entity)player, tool);
            if (exp > 0) {
                state.getBlock().popExperience(level, pos, exp);
            }
        }
        return broken;
    }
}

