/*
 * Decompiled with CFR 0.152.
 */
package net.dafarka.jeirecipechains.compatibility;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.dafarka.jeirecipechains.base.ChainNode;
import net.dafarka.jeirecipechains.base.ChainType;
import net.dafarka.jeirecipechains.base.RecipeChain;
import net.dafarka.jeirecipechains.compatibility.JEIRecipeChainsPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ChainCategory
implements IRecipeCategory<RecipeChain> {
    private static final ResourceLocation ICON_TEXTURE = new ResourceLocation("jeirecipechains", "textures/gui/icon_16x16.png");
    private final IDrawable icon;
    private final IDrawable background;
    private final Component title;
    private static final int SPACING_X = 20;
    private static final int SPACING_Y = 20;
    private final Map<ChainNode, Point> nodePositions = new HashMap<ChainNode, Point>();

    public ChainCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(320, 240);
        this.title = Component.m_237115_((String)"chain.category.title");
        IDrawableBuilder builder = helper.drawableBuilder(ICON_TEXTURE, 0, 0, 16, 16);
        builder.setTextureSize(16, 16);
        this.icon = builder.build();
    }

    public RecipeType<RecipeChain> getRecipeType() {
        return JEIRecipeChainsPlugin.CHAIN_RECIPE_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeChain recipe, IFocusGroup focuses) {
        this.renderTree(builder, recipe.getRoot(), this.getWidth() / 2, 8);
    }

    private int renderTree(IRecipeLayoutBuilder builder, ChainNode node, int x, int y) {
        if (node == null) {
            return y;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStack(node.getStack());
        this.nodePositions.put(node, new Point(x, y));
        int childY = y + 20;
        for (ChainNode child : node.getChildren()) {
            int childX = this.getChildX(child, x, node.getChildren());
            builder.addSlot(RecipeIngredientRole.INPUT, childX, childY).addItemStack(child.getStack());
            this.nodePositions.put(child, new Point(childX, childY));
            this.renderTree(builder, child, childX, childY);
        }
        return childY + 20;
    }

    private int computeSubtreeWidth(ChainNode node) {
        if (node.getChildren().isEmpty()) {
            return 1;
        }
        int width = 0;
        for (ChainNode child : node.getChildren()) {
            width += this.computeSubtreeWidth(child);
        }
        return Math.max(width, node.getChildren().size());
    }

    private int getChildX(ChainNode child, int parentX, List<ChainNode> siblings) {
        if (siblings == null || siblings.isEmpty()) {
            return parentX;
        }
        int total = siblings.size();
        int index = siblings.indexOf(child);
        if (index < 0) {
            return parentX;
        }
        double[] widths = new double[total];
        double totalWidth = 0.0;
        for (int i = 0; i < total; ++i) {
            widths[i] = this.computeSubtreeWidth(siblings.get(i));
            totalWidth += widths[i];
        }
        double[] centers = new double[total];
        double cumulative = 0.0;
        for (int i = 0; i < total; ++i) {
            centers[i] = cumulative + widths[i] / 2.0;
            cumulative += widths[i];
        }
        double groupCenter = totalWidth / 2.0;
        double localOffset = centers[index] - groupCenter;
        double pixelOffset = localOffset * 20.0;
        return parentX + (int)Math.round(pixelOffset);
    }

    public void draw(RecipeChain recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.drawBoxesFromMap(graphics, recipe.getRoot());
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        this.drawRectange(graphics, 2, 2, 8, 8, -16711936);
        this.drawRectange(graphics, 2, 16, 8, 8, -16776961);
        graphics.m_280056_(font, "Craft Together", 12, 2, 0, false);
        graphics.m_280056_(font, "Alternatives", 12, 16, 0, false);
    }

    private void drawBoxesFromMap(GuiGraphics guiGraphics, ChainNode node) {
        int color = node.getType() == ChainType.AND ? 65280 : 255;
        List<ChainNode> children = node.getChildren();
        if (children.isEmpty()) {
            return;
        }
        ArrayList<Point> points = new ArrayList<Point>();
        for (ChainNode child : children) {
            Point p2 = this.nodePositions.get(child);
            if (p2 == null) continue;
            points.add(p2);
        }
        if (!points.isEmpty()) {
            int minX = points.stream().mapToInt(p -> p.x).min().orElse(0);
            int maxX = points.stream().mapToInt(p -> p.x).max().orElse(0);
            int minY = points.stream().mapToInt(p -> p.y).min().orElse(0);
            int maxY = points.stream().mapToInt(p -> p.y).max().orElse(0);
            this.drawRectange(guiGraphics, minX, minY, maxX - minX + 16, maxY - minY + 16, 0x40000000 + color);
        }
        for (ChainNode child : children) {
            this.drawBoxesFromMap(guiGraphics, child);
        }
    }

    private void drawRectange(GuiGraphics guiGraphics, int x, int y, int width, int height, int color) {
        guiGraphics.m_280509_(x, y, x + width, y + height, color);
    }
}

