/*
 * Decompiled with CFR 0.152.
 */
package net.dafarka.jeirecipechains.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.dafarka.jeirecipechains.base.ChainNode;
import net.dafarka.jeirecipechains.base.ChainType;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

public class ChainBuilder {
    private final RecipeManager recipeManager;
    private final RegistryAccess registryAccess;
    private final Set<Item> excludedItems;

    public ChainBuilder(RecipeManager recipeManager, RegistryAccess registryAccess, Set<Item> excludedItems) {
        this.recipeManager = recipeManager;
        this.registryAccess = registryAccess;
        this.excludedItems = excludedItems;
    }

    public ChainNode buildChain(Item item, int depth, Set<Item> path) {
        if (depth > 8) {
            return new ChainNode(new ItemStack((ItemLike)item));
        }
        if (this.excludedItems.contains(item)) {
            return null;
        }
        if (path.contains(item)) {
            return new ChainNode(new ItemStack((ItemLike)item));
        }
        ChainNode node = new ChainNode(new ItemStack((ItemLike)item));
        path.add(item);
        List<Recipe> producingRecipes = this.recipeManager.m_44051_().stream().filter(r -> r.m_8043_(this.registryAccess).m_41720_() == item).toList();
        if (producingRecipes.size() > 1) {
            node.setType(ChainType.OR);
        }
        for (Recipe recipe : this.recipeManager.m_44051_()) {
            ItemStack result = recipe.m_8043_(this.registryAccess);
            if (result.m_41720_() != item) continue;
            HashMap<Item, Integer> ingredientCounts = new HashMap<Item, Integer>();
            for (Ingredient ing : recipe.m_7527_()) {
                ItemStack chosen;
                Item unique;
                ItemStack[] options = ing.m_43908_();
                if (options.length == 0 || this.excludedItems.contains(unique = (chosen = options[0]).m_41720_())) continue;
                ingredientCounts.merge(unique, chosen.m_41613_(), Integer::sum);
            }
            for (Map.Entry entry : ingredientCounts.entrySet()) {
                Item child = (Item)entry.getKey();
                ItemStack childStack = new ItemStack((ItemLike)child, ((Integer)entry.getValue()).intValue());
                ChainNode childNode = this.buildChain(child, depth + 1, new HashSet<Item>(path));
                if (childNode == null) continue;
                childNode.setStack(childStack);
                node.addChild(childNode);
            }
        }
        return node;
    }
}

