/*
 * Decompiled with CFR 0.152.
 */
package net.dafarka.jeirecipechains.util;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SmeltingRecipe;

public class ExclusionUtil {
    private static final String[] COLOR_NAMES = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};

    public static Set<Item> getExcludedItems(RecipeManager recipeManager, RegistryAccess registryAccess) {
        HashSet<Item> excluded = new HashSet<Item>();
        excluded.addAll(ExclusionUtil.getColoredItems());
        excluded.addAll(ExclusionUtil.getRecyclables(recipeManager, registryAccess));
        excluded.addAll(ExclusionUtil.getRawBlocks());
        return excluded;
    }

    private static Set<Item> getRecyclables(RecipeManager recipeManager, RegistryAccess registryAccess) {
        HashSet<Item> excluded = new HashSet<Item>();
        for (Recipe recipe : recipeManager.m_44051_()) {
            if (!(recipe instanceof SmeltingRecipe)) continue;
            SmeltingRecipe smelt = (SmeltingRecipe)recipe;
            Item output = smelt.m_8043_(registryAccess).m_41720_();
            for (Ingredient ing : smelt.m_7527_()) {
                for (ItemStack stack : ing.m_43908_()) {
                    Item input = stack.m_41720_();
                    if (!ExclusionUtil.isRecyclable(input, output)) continue;
                    excluded.add(input);
                }
            }
        }
        return excluded;
    }

    private static boolean isRecyclable(Item input, Item output) {
        String inputName = BuiltInRegistries.f_257033_.m_7981_((Object)input).m_135815_();
        String outputName = BuiltInRegistries.f_257033_.m_7981_((Object)output).m_135815_();
        return (inputName.contains("pickaxe") || inputName.contains("axe") || inputName.contains("shovel") || inputName.contains("sword") || inputName.contains("helmet") || inputName.contains("chestplate") || inputName.contains("hoe") || inputName.contains("horse_armor") || inputName.contains("leggings") || inputName.contains("boots")) && outputName.contains("nugget");
    }

    private static Set<Item> getColoredItems() {
        HashSet<Item> excluded = new HashSet<Item>();
        block0: for (Item item : BuiltInRegistries.f_257033_) {
            String name = BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_();
            for (String color : COLOR_NAMES) {
                if (!name.startsWith(color + "_")) continue;
                excluded.add(item);
                continue block0;
            }
        }
        return excluded;
    }

    public static Set<Item> getRawBlocks() {
        HashSet<Item> excluded = new HashSet<Item>();
        for (Item item : BuiltInRegistries.f_257033_) {
            String path = BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_();
            if (!path.startsWith("raw_")) continue;
            excluded.add(item);
        }
        return excluded;
    }
}

