/*
 * Decompiled with CFR 0.152.
 */
package com.yourmod.wolfarmor;

import com.mojang.logging.LogUtils;
import com.yourmod.wolfarmor.client.models.entity.ArmadilloModel;
import com.yourmod.wolfarmor.client.renderers.entity.ArmadilloRenderer;
import com.yourmod.wolfarmor.init.ModArmorMaterials;
import com.yourmod.wolfarmor.init.ModEntities;
import com.yourmod.wolfarmor.init.ModSounds;
import com.yourmod.wolfarmor.item.WolfArmorItem;
import com.yourmod.wolfarmor.server.entities.Armadillo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="wolfarmor")
public class WolfArmorMod {
    public static final String MODID = "wolfarmor";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"wolfarmor");
    public static final RegistryObject<Item> ARMADILLO_SCUTE = ITEMS.register("armadillo_scute", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> WOLF_ARMOR = ITEMS.register("wolf_armor", () -> new WolfArmorItem(ModArmorMaterials.WOLF_ARMOR, new Item.Properties().m_41487_(1).m_41503_(64)));

    public WolfArmorMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModSounds.SOUNDS.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::addCreative);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Wolf Armor Mod initialized");
        event.enqueueWork(() -> ModEntities.registerSpawnPlacements());
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256797_) {
            event.m_246326_((ItemLike)WOLF_ARMOR.get());
        }
        if (event.getTabKey() == CreativeModeTabs.f_256968_) {
            event.m_246326_((ItemLike)ARMADILLO_SCUTE.get());
        }
        if (event.getTabKey() == CreativeModeTabs.f_256731_) {
            event.m_246326_((ItemLike)ModEntities.ARMADILLO_SPAWN_EGG.get());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onPlayerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof Armadillo) {
            Armadillo armadillo = (Armadillo)entity;
            if (event.getItemStack().m_41720_() == Items.f_271356_ && armadillo.brush(event.getEntity(), event.getItemStack())) {
                event.setCanceled(true);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="wolfarmor", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class CommonModEvents {
        @SubscribeEvent
        public static void entityAttributeEvent(EntityAttributeCreationEvent event) {
            event.put((EntityType)ModEntities.ARMADILLO.get(), Armadillo.createAttributes().m_22265_());
        }
    }

    @Mod.EventBusSubscriber(modid="wolfarmor", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }

        @SubscribeEvent
        public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
            event.register((stack, tintIndex) -> {
                if (tintIndex > 0 && stack.m_41720_() instanceof WolfArmorItem) {
                    WolfArmorItem armorItem = (WolfArmorItem)stack.m_41720_();
                    return armorItem.m_41121_(stack);
                }
                return -1;
            }, new ItemLike[]{(ItemLike)WOLF_ARMOR.get()});
        }

        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)ModEntities.ARMADILLO.get(), ArmadilloRenderer::new);
        }

        @SubscribeEvent
        public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(ArmadilloModel.ARMADILLO, ArmadilloModel::createBodyLayer);
        }
    }
}

