/*
 * Decompiled with CFR 0.152.
 */
package com.yourmod.wolfarmor.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yourmod.wolfarmor.init.ModModelLayers;
import com.yourmod.wolfarmor.item.WolfArmorItem;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WolfArmorLayer
extends RenderLayer<Wolf, WolfModel<Wolf>> {
    private final WolfModel<Wolf> model;
    private static final ResourceLocation WOLF_ARMOR_BASE = new ResourceLocation("wolfarmor", "textures/entity/wolf/wolf_armor.png");
    private static final ResourceLocation WOLF_ARMOR_OVERLAY = new ResourceLocation("wolfarmor", "textures/entity/wolf/wolf_armor_overlay.png");
    private static final ResourceLocation WOLF_ARMOR_CRACKINESS_LOW = new ResourceLocation("wolfarmor", "textures/entity/wolf/wolf_armor_crackiness_low.png");
    private static final ResourceLocation WOLF_ARMOR_CRACKINESS_MEDIUM = new ResourceLocation("wolfarmor", "textures/entity/wolf/wolf_armor_crackiness_medium.png");
    private static final ResourceLocation WOLF_ARMOR_CRACKINESS_HIGH = new ResourceLocation("wolfarmor", "textures/entity/wolf/wolf_armor_crackiness_high.png");

    public WolfArmorLayer(RenderLayerParent<Wolf, WolfModel<Wolf>> layerParent, EntityModelSet modelSet) {
        super(layerParent);
        this.model = new WolfModel(modelSet.m_171103_(ModModelLayers.WOLF_ARMOR));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, Wolf wolf, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack = wolf.m_6844_(EquipmentSlot.CHEST);
        Item item = stack.m_41720_();
        if (item instanceof WolfArmorItem) {
            WolfArmorItem wolfArmorItem = (WolfArmorItem)item;
            ((WolfModel)this.m_117386_()).m_102624_(this.model);
            this.model.m_6839_(wolf, limbSwing, limbSwingAmount, partialTicks);
            this.model.m_6973_(wolf, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            int color = wolfArmorItem.m_41121_(stack);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            float durability = 1.0f - (float)stack.m_41773_() / (float)stack.m_41776_();
            VertexConsumer baseConsumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)WOLF_ARMOR_BASE));
            this.model.m_7695_(poseStack, baseConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            VertexConsumer overlayConsumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)WOLF_ARMOR_OVERLAY));
            this.model.m_7695_(poseStack, overlayConsumer, packedLight, OverlayTexture.f_118083_, red, green, blue, 1.0f);
            this.renderCrackTextures(poseStack, bufferSource, packedLight, durability);
        }
    }

    private void renderCrackTextures(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float durability) {
        if (durability < 0.7f) {
            ResourceLocation crackTexture = this.getCrackTextureForDurability(durability);
            float crackAlpha = this.getCrackAlphaForDurability(durability);
            if (crackAlpha > 0.0f) {
                VertexConsumer crackConsumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)crackTexture));
                this.model.m_7695_(poseStack, crackConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, crackAlpha);
            }
        }
    }

    private ResourceLocation getCrackTextureForDurability(float durability) {
        if (durability < 0.3f) {
            return WOLF_ARMOR_CRACKINESS_HIGH;
        }
        if (durability < 0.5f) {
            return WOLF_ARMOR_CRACKINESS_MEDIUM;
        }
        return WOLF_ARMOR_CRACKINESS_LOW;
    }

    private float getCrackAlphaForDurability(float durability) {
        if (durability < 0.3f) {
            return 1.0f;
        }
        if (durability < 0.5f) {
            return 0.7f;
        }
        return 0.4f;
    }
}

