/*
 * Decompiled with CFR 0.152.
 */
package com.yourmod.wolfarmor.init.mixin;

import com.yourmod.wolfarmor.init.mixin.MobEntityMixin;
import com.yourmod.wolfarmor.tags.ModBiomeTags;
import com.yourmod.wolfarmor.variant.WolfEntityVariant;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Wolf.class})
public abstract class WolfEntityMixin
extends MobEntityMixin {
    @Unique
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Wolf.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    @Inject(method={"defineSynchedData"}, at={@At(value="HEAD")})
    public void initTracker(CallbackInfo ci) {
        Wolf wolfEntity = (Wolf)this;
        wolfEntity.m_20088_().m_135372_(VARIANT, (Object)0);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    public void writeNBTData(CompoundTag pCompound, CallbackInfo ci) {
        pCompound.m_128405_("Variant", this.getTypeVariant());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    public void readNBTData(CompoundTag pCompound, CallbackInfo ci) {
        Wolf wolfEntity = (Wolf)this;
        wolfEntity.m_20088_().m_135381_(VARIANT, (Object)pCompound.m_128451_("Variant"));
    }

    @Override
    protected void onInitialize(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, SpawnGroupData pSpawnData, CompoundTag pDataTag, CallbackInfoReturnable<SpawnGroupData> cir) {
        Wolf wolfEntity = (Wolf)this;
        Holder registryEntry = pLevel.m_204166_(wolfEntity.m_20097_());
        WolfEntityVariant variant = WolfEntityVariant.byId(WolfEntityVariant.PALE_WOLF.getId());
        if (registryEntry.m_203656_(ModBiomeTags.SPAWNS_WOODS_WOLF)) {
            variant = WolfEntityVariant.WOODS_WOLF;
        } else if (registryEntry.m_203656_(ModBiomeTags.SPAWNS_ASHEN_WOLF)) {
            variant = WolfEntityVariant.ASHEN_WOLF;
        } else if (registryEntry.m_203656_(ModBiomeTags.SPAWNS_BLACK_WOLF)) {
            variant = WolfEntityVariant.BLACK_WOLF;
        } else if (registryEntry.m_203656_(ModBiomeTags.SPAWNS_CHESTNUT_WOLF)) {
            variant = WolfEntityVariant.CHESTNUT_WOLF;
        } else if (registryEntry.m_203656_(ModBiomeTags.SPAWNS_RUSTY_WOLF)) {
            variant = WolfEntityVariant.RUSTY_WOLF;
        } else if (registryEntry.m_203656_(ModBiomeTags.SPAWNS_SPOTTED_WOLF)) {
            variant = WolfEntityVariant.SPOTTED_WOLF;
        } else if (registryEntry.m_203656_(ModBiomeTags.SPAWNS_STRIPED_WOLF)) {
            variant = WolfEntityVariant.STRIPED_WOLF;
        } else if (registryEntry.m_203656_(ModBiomeTags.SPAWNS_SNOWY_WOLF)) {
            variant = WolfEntityVariant.SNOWY_WOLF;
        }
        this.setVariant(variant);
    }

    @Inject(method={"getBreedOffspring(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lnet/minecraft/world/entity/animal/Wolf;"}, at={@At(value="RETURN")})
    private void onCreateChild(ServerLevel pLevel, AgeableMob pOtherParent, CallbackInfoReturnable<Wolf> cir) {
        Wolf child = (Wolf)cir.getReturnValue();
        Wolf wolfEntity = (Wolf)this;
        CompoundTag childNbt = new CompoundTag();
        child.m_7380_(childNbt);
        CompoundTag nbtParent = new CompoundTag();
        wolfEntity.m_7380_(nbtParent);
        CompoundTag nbtOtherParent = new CompoundTag();
        pOtherParent.m_7380_(nbtOtherParent);
        int variant = wolfEntity.m_217043_().m_188499_() ? nbtParent.m_128451_("Variant") : nbtOtherParent.m_128451_("Variant");
        child.m_20088_().m_135381_(VARIANT, (Object)(variant & 0xFF));
        childNbt.m_128405_("Variant", variant);
        child.m_7378_(childNbt);
    }

    public WolfEntityVariant getVariant() {
        return WolfEntityVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public int getTypeVariant() {
        Wolf wolfEntity = (Wolf)this;
        return (Integer)wolfEntity.m_20088_().m_135370_(VARIANT);
    }

    public void setVariant(WolfEntityVariant variant) {
        Wolf wolfEntity = (Wolf)this;
        wolfEntity.m_20088_().m_135381_(VARIANT, (Object)(variant.getId() & 0xFF));
    }
}

