/*
 * Decompiled with CFR 0.152.
 */
package com.yourmod.wolfarmor.init.mixin;

import com.yourmod.wolfarmor.item.WolfArmorItem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.ToolActions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Wolf.class})
public abstract class WolfMixin {
    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    public void mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        Wolf entity = (Wolf)this;
        ItemStack stack = player.m_21120_(hand);
        if (this.isEquippable(stack) && entity.m_6844_(EquipmentSlot.CHEST).m_41619_() && !entity.m_6162_() && entity.m_21824_() && entity.m_21805_() != null && entity.m_21805_().equals(player.m_20148_())) {
            ItemStack armorCopy = stack.m_255036_(1);
            entity.m_8061_(EquipmentSlot.CHEST, armorCopy);
            Item item = stack.m_41720_();
            if (item instanceof WolfArmorItem) {
                WolfArmorItem animalArmorItem = (WolfArmorItem)item;
                entity.m_5496_(animalArmorItem.getEquipSound(), 1.0f, 1.0f);
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        } else if (this.shearable() && (stack.m_41720_() instanceof ShearsItem || stack.canPerformAction(ToolActions.SHEARS_HARVEST)) && entity.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof WolfArmorItem && (!EnchantmentHelper.m_44920_((ItemStack)entity.m_6844_(EquipmentSlot.CHEST)) || player.m_7500_()) && entity.m_21824_() && entity.m_21805_() != null && entity.m_21805_().equals(player.m_20148_())) {
            stack.m_41622_(1, (LivingEntity)player, a -> a.m_21190_(hand));
            entity.m_216990_(SoundEvents.f_12344_);
            ItemStack armor = entity.m_6844_(EquipmentSlot.CHEST);
            entity.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
            entity.m_19983_(armor);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void onHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Wolf entity = (Wolf)this;
        ItemStack armorStack = entity.m_6844_(EquipmentSlot.CHEST);
        Item item = armorStack.m_41720_();
        if (item instanceof WolfArmorItem) {
            WolfArmorItem wolfArmor = (WolfArmorItem)item;
            if (!armorStack.m_41619_() && wolfArmor.onWolfDamaged(entity, armorStack, source, amount)) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Unique
    private boolean isEquippable(ItemStack stack) {
        return stack.m_41720_() instanceof WolfArmorItem;
    }

    @Unique
    private boolean shearable() {
        Shearable shearable;
        Wolf entity = (Wolf)this;
        return !(entity instanceof Shearable) || !(shearable = (Shearable)entity).m_6220_();
    }
}

