/*
 * Decompiled with CFR 0.152.
 */
package com.yourmod.wolfarmor.item;

import com.yourmod.wolfarmor.init.AnimalArmorMaterial;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;

public class WolfArmorItem
extends Item
implements DyeableLeatherItem {
    private final AnimalArmorMaterial material;

    public WolfArmorItem(AnimalArmorMaterial material, Item.Properties properties) {
        super(properties.m_41499_(material.getDurability()));
        this.material = material;
    }

    public AnimalArmorMaterial getMaterial() {
        return this.material;
    }

    public int m_41121_(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41737_("display");
        return compoundtag != null && compoundtag.m_128425_("color", 99) ? compoundtag.m_128451_("color") : this.getDefaultColor();
    }

    private int getDefaultColor() {
        return 10511680;
    }

    public void removeColor(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41737_("display");
        if (compoundtag != null && compoundtag.m_128441_("color")) {
            compoundtag.m_128473_("color");
        }
    }

    public boolean m_41113_(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41737_("display");
        return compoundtag != null && compoundtag.m_128425_("color", 99);
    }

    public boolean onWolfDamaged(Wolf wolf, ItemStack armorStack, DamageSource source, float amount) {
        int damageAmount = (int)Math.ceil(amount);
        armorStack.m_41622_(damageAmount, (LivingEntity)wolf, entity -> entity.m_21166_(EquipmentSlot.CHEST));
        wolf.m_5496_(this.material.getEquipSound(), 0.5f, 1.0f);
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack armorStack;
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        if (level.m_8055_(blockpos).m_60713_(Blocks.f_152476_) && this.m_41113_(armorStack = context.m_43722_())) {
            if (!level.f_46443_) {
                this.removeColor(armorStack);
                LayeredCauldronBlock.m_153559_((BlockState)level.m_8055_(blockpos), (Level)level, (BlockPos)blockpos);
                level.m_5594_(null, blockpos, SoundEvents.f_11917_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public SoundEvent getEquipSound() {
        return this.material.getEquipSound();
    }

    public int getDurability() {
        return this.material.getDurability();
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairCandidate) {
        return this.material.getRepairIngredient().test(repairCandidate);
    }

    public boolean m_41465_() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.getDurability();
    }

    public boolean isRepairable(ItemStack stack) {
        return true;
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }
}

