/*
 * Decompiled with CFR 0.152.
 */
package com.yourmod.wolfarmor.server.entities;

import com.yourmod.wolfarmor.WolfArmorMod;
import com.yourmod.wolfarmor.init.ModEntities;
import com.yourmod.wolfarmor.init.ModSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class Armadillo
extends Animal {
    private int rolledUpTime = 0;
    private int threatCheckTimer = 0;
    private int scuteShedTimer = 0;
    private int extendedRollTime = 0;
    private static final int UNROLL_TIME = 100;
    private static final int EXTENDED_UNROLL_TIME = 200;
    private static final int SCUTE_SHED_INTERVAL = 12000;
    public final AnimationState rollUpAnimationState = new AnimationState();
    public final AnimationState rollOutAnimationState = new AnimationState();
    public final AnimationState peekAnimationState = new AnimationState();
    private boolean wasRolledUp = false;
    private int lastHurtTimestamp = 0;

    public Armadillo(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22284_, 2.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42591_}), false){

            public boolean m_8036_() {
                if (Armadillo.this.isRolledUp()) {
                    return false;
                }
                return super.m_8036_();
            }

            public boolean m_8045_() {
                if (Armadillo.this.isRolledUp()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal(this, 1.1){

            public boolean m_8036_() {
                if (Armadillo.this.isRolledUp()) {
                    return false;
                }
                return super.m_8036_();
            }

            public boolean m_8045_() {
                if (Armadillo.this.isRolledUp()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                if (Armadillo.this.isRolledUp()) {
                    return false;
                }
                return super.m_8036_();
            }

            public boolean m_8045_() {
                if (Armadillo.this.isRolledUp()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8119_() {
        super.m_8119_();
        boolean currentlyRolledUp = this.isRolledUp();
        if (!this.m_9236_().f_46443_) {
            this.updateRolledUpState();
            this.updateScuteShedding();
        } else {
            this.setupAnimationStates(currentlyRolledUp);
        }
        this.wasRolledUp = currentlyRolledUp;
    }

    private void updateRolledUpState() {
        boolean hasThreats = this.shouldHideInShell();
        if (hasThreats) {
            if (this.rolledUpTime == 0) {
                this.rolledUpTime = this.f_19797_;
            }
            this.m_21573_().m_26573_();
            this.m_21566_().m_6849_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0);
        } else {
            int requiredUnrollTime;
            int n = requiredUnrollTime = this.extendedRollTime > 0 ? 200 : 100;
            if (this.rolledUpTime > 0 && this.f_19797_ - this.rolledUpTime > requiredUnrollTime) {
                this.rolledUpTime = 0;
                this.extendedRollTime = 0;
            }
        }
    }

    private void updateScuteShedding() {
        if (this.scuteShedTimer++ >= 12000) {
            this.scuteShedTimer = 0;
            if (this.f_19796_.m_188503_(3) == 0) {
                this.m_5496_((SoundEvent)ModSounds.ARMADILLO_SCUTE_DROP.get(), 0.8f, 1.0f);
                this.m_19998_((ItemLike)WolfArmorMod.ARMADILLO_SCUTE.get());
            }
        }
    }

    private void setupAnimationStates(boolean currentlyRolledUp) {
        if (currentlyRolledUp && !this.wasRolledUp) {
            this.rollUpAnimationState.m_216977_(this.f_19797_);
            this.rollOutAnimationState.m_216973_();
            this.peekAnimationState.m_216973_();
        } else if (!currentlyRolledUp && this.wasRolledUp) {
            this.rollOutAnimationState.m_216977_(this.f_19797_);
            this.rollUpAnimationState.m_216973_();
            this.peekAnimationState.m_216973_();
        }
        if (currentlyRolledUp && this.f_19797_ % 100 == 0 && this.f_19796_.m_188503_(3) == 0) {
            this.peekAnimationState.m_216977_(this.f_19797_);
        }
    }

    public boolean shouldHideInShell() {
        if (this.m_5830_()) {
            return true;
        }
        if (this.f_19797_ - this.lastHurtTimestamp < 100) {
            return true;
        }
        AABB threatArea = this.m_20191_().m_82400_(8.0);
        List nearbyEntities = this.m_9236_().m_45976_(LivingEntity.class, threatArea);
        for (LivingEntity entity : nearbyEntities) {
            if (!this.isThreat(entity)) continue;
            return true;
        }
        return false;
    }

    private boolean isThreat(LivingEntity entity) {
        if (entity instanceof Monster && !(entity instanceof Spider)) {
            return true;
        }
        if (entity instanceof Player) {
            if (this.m_21188_() == entity) {
                return true;
            }
            Player player = (Player)entity;
            if (player.m_20142_() || player.m_20159_()) {
                return true;
            }
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return !this.isRolledUp() ? (SoundEvent)ModSounds.ARMADILLO_AMBIENT.get() : null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.ARMADILLO_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ARMADILLO_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        if (!this.isRolledUp() && (this.f_267362_.m_267780_() || this.m_20184_().m_165925_() > 0.01)) {
            this.m_5496_((SoundEvent)ModSounds.ARMADILLO_STEP.get(), 0.15f, 1.0f);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_6898_(itemstack)) {
            int previousLoveTime = this.m_27591_();
            InteractionResult result = super.m_6071_(player, hand);
            if (result.m_19077_() && (this.m_27591_() != previousLoveTime || this.m_27593_())) {
                this.m_5496_((SoundEvent)ModSounds.ARMADILLO_EAT.get(), 1.0f, 1.0f);
            }
            return result;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean hurt;
        if (this.isRolledUp()) {
            amount *= 0.3f;
        }
        if (hurt = super.m_6469_(source, amount)) {
            this.rolledUpTime = this.f_19797_;
            this.extendedRollTime = this.f_19797_;
            this.lastHurtTimestamp = this.f_19797_;
        }
        return hurt;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.isRolledUp()) {
            this.repelSpiders();
        }
    }

    private void repelSpiders() {
        AABB repelArea = this.m_20191_().m_82400_(6.0);
        List spiders = this.m_9236_().m_45976_(Spider.class, repelArea);
        for (Spider spider : spiders) {
            double dz;
            double dx = spider.m_20185_() - this.m_20185_();
            double distance = Math.sqrt(dx * dx + (dz = spider.m_20189_() - this.m_20189_()) * dz);
            if (!(distance < 5.0)) continue;
            double strength = 1.0 - distance / 5.0;
            spider.m_20256_(spider.m_20184_().m_82520_(dx / distance * strength * 0.1, 0.0, dz / distance * strength * 0.1));
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42591_;
    }

    public boolean m_5957_() {
        return super.m_5957_() && !this.isRolledUp();
    }

    public void m_27595_(@Nullable Player player) {
        if (!this.isRolledUp()) {
            super.m_27595_(player);
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        return (AgeableMob)((EntityType)ModEntities.ARMADILLO.get()).m_20615_((Level)level);
    }

    protected void m_7472_(DamageSource source, int lootingMultiplier, boolean recentlyHit) {
        super.m_7472_(source, lootingMultiplier, recentlyHit);
        if (source.m_7639_() instanceof Player || source.m_7639_() instanceof Wolf && ((Wolf)source.m_7639_()).m_21824_()) {
            int xpCount = 1 + this.f_19796_.m_188503_(3);
            for (int i = 0; i < xpCount; ++i) {
                this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1));
            }
        }
    }

    public boolean brush(Player player, ItemStack brush) {
        if (this.isRolledUp()) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            brush.m_41622_(16, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
            this.m_5496_((SoundEvent)ModSounds.ARMADILLO_BRUSH.get(), 1.0f, 1.0f);
            if (this.f_19796_.m_188503_(1) == 0) {
                this.m_19998_((ItemLike)WolfArmorMod.ARMADILLO_SCUTE.get());
            }
            return true;
        }
        return false;
    }

    public boolean isRolledUp() {
        return this.shouldHideInShell() || this.rolledUpTime > 0 || this.extendedRollTime > 0;
    }
}

