/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.api;

import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.impl.ImmutableStateManager;
import dev.isxander.yacl3.impl.InstantStateManager;
import dev.isxander.yacl3.impl.SimpleStateManager;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public interface StateManager<T> {
    public static <T> StateManager<T> createSimple(Binding<T> binding) {
        return new SimpleStateManager<T>(binding);
    }

    public static <T> StateManager<T> createSimple(@NotNull T def, @NotNull @NotNull Supplier<@NotNull T> getter, @NotNull @NotNull Consumer<@NotNull T> setter) {
        return new SimpleStateManager<T>(Binding.generic(def, getter, setter));
    }

    public static <T> StateManager<T> createInstant(Binding<T> binding) {
        return new InstantStateManager<T>(binding);
    }

    public static <T> StateManager<T> createInstant(@NotNull T def, @NotNull @NotNull Supplier<@NotNull T> getter, @NotNull @NotNull Consumer<@NotNull T> setter) {
        return new InstantStateManager<T>(Binding.generic(def, getter, setter));
    }

    public static <T> StateManager<T> createImmutable(@NotNull T value) {
        return new ImmutableStateManager<T>(value);
    }

    public void set(T var1);

    public T get();

    public void apply();

    public void resetToDefault(ResetAction var1);

    public void sync();

    public boolean isSynced();

    default public boolean isAlwaysSynced() {
        return false;
    }

    public boolean isDefault();

    public void addListener(StateListener<T> var1);

    public static interface StateListener<T> {
        public static <T> StateListener<T> noop() {
            return (oldValue, newValue) -> {};
        }

        public void onStateChange(T var1, T var2);

        default public StateListener<T> andThen(StateListener<T> after) {
            return (oldValue, newValue) -> {
                this.onStateChange(oldValue, newValue);
                after.onStateChange(oldValue, newValue);
            };
        }
    }

    public static enum ResetAction {
        BY_OPTION,
        BY_GLOBAL;

    }
}

