/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity.model.loader;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.entity.model.loader.BedrockEntityModelLoader;
import com.supermartijn642.fusion.entity.model.loader.EntityModelLoader;
import com.supermartijn642.fusion.entity.model.loader.OptifineEntityModelLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3304;
import net.minecraft.class_5601;
import net.minecraft.class_630;
import net.minecraft.class_6861;

public class FusionEntityModelLoader {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final List<Pair<String, EntityModelLoader>> LOADERS = List.of(Pair.of(".geo.json", new BedrockEntityModelLoader()), Pair.of(".jem", new OptifineEntityModelLoader()));
    public static Map<class_2960, class_630> MODELS = Map.of();

    public static class_2960 locationForLayer(class_5601 layer) {
        String layerFormatted = layer.method_35744().toLowerCase(Locale.ROOT).replace(':', '/').replaceAll("[^a-z0-9/._-]", "");
        return layer.method_35743().method_48331("/" + layerFormatted);
    }

    public static void loadModels(List<class_2960> identifiers, class_3300 resourceManager) {
        Map<class_3262, Integer> packOrder = Collections.emptyMap();
        if (resourceManager instanceof class_6861 || resourceManager instanceof class_3304 && ((class_3304)resourceManager).field_36391 instanceof class_6861) {
            List packs = resourceManager instanceof class_3304 ? ((class_6861)((class_3304)resourceManager).field_36391).field_36390 : ((class_6861)resourceManager).field_36390;
            packOrder = new HashMap(packs.size());
            for (int index = 0; index < packs.size(); ++index) {
                packOrder.put((class_3262)packs.get(index), index);
            }
        }
        ImmutableMap.Builder models = ImmutableMap.builder();
        for (class_2960 identifier : identifiers) {
            class_630 model;
            class_3298 resource = null;
            EntityModelLoader modelLoader = null;
            class_2960 location = null;
            int packIndex = -1;
            for (Pair<String, EntityModelLoader> loader : LOADERS) {
                class_3298 r;
                int index;
                class_2960 l = new class_2960(identifier.method_12836(), "fusion/entity_models/" + identifier.method_12832() + loader.left());
                Optional optional = resourceManager.method_14486(l);
                if (!optional.isPresent() || (index = ((Integer)packOrder.get((r = (class_3298)optional.get()).method_45304())).intValue()) <= packIndex) continue;
                resource = r;
                modelLoader = loader.right();
                location = l;
                packIndex = index;
            }
            if (resource == null || (model = FusionEntityModelLoader.loadModel(location, resource, modelLoader)) == null) continue;
            models.put((Object)identifier, (Object)model);
        }
        MODELS = models.build();
    }

    private static class_630 loadModel(class_2960 location, class_3298 resource, EntityModelLoader loader) {
        JsonObject json = new JsonObject();
        try (BufferedReader input = resource.method_43039();){
            json = (JsonObject)GSON.fromJson((Reader)input, JsonObject.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read resource for '" + String.valueOf(location) + "' from pack '" + resource.method_45304().method_14409(), e);
        }
        catch (JsonSyntaxException e) {
            FusionClient.LOGGER.error("Failed to parse json for '{}' from pack '{}': {}", new Object[]{location, resource.method_45304().method_14409(), e.getMessage()});
        }
        if (json == null) {
            return null;
        }
        try {
            return loader.loadModel(json);
        }
        catch (JsonParseException e) {
            FusionClient.LOGGER.error("Failed to load entity model for '{}' from pack '{}': {}", new Object[]{location, resource.method_45304().method_14409(), e.getMessage()});
            return null;
        }
    }
}

