/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.entity.EntityModelModifierManager;
import com.supermartijn642.fusion.extensions.EntityExtension;
import com.supermartijn642.fusion.util.Triple;
import java.util.Arrays;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_630;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_1297.class})
public class EntityMixin
implements EntityExtension {
    @Unique
    private Triple<class_630, class_2960, Float>[] models;
    @Unique
    private int lastReload = -1;

    @Override
    public Triple<class_630, class_2960, Float> getFusionModel(int layerIndex) {
        return this.models[layerIndex];
    }

    @Override
    public void setFusionModel(int layerIndex, Triple<class_630, class_2960, Float> model) {
        if (this.lastReload != EntityModelModifierManager.reloadCounter) {
            if (this.models != null) {
                Arrays.fill(this.models, null);
            }
            this.lastReload = EntityModelModifierManager.reloadCounter;
        }
        if (this.models == null) {
            this.models = new Triple[layerIndex + 1];
        } else if (this.models.length <= layerIndex) {
            Triple[] newModels = new Triple[layerIndex + 1];
            System.arraycopy(this.models, 0, newModels, 0, layerIndex);
            this.models = newModels;
        }
        this.models[layerIndex] = model;
    }

    @Override
    public boolean shouldFusionRecomputeModel(int layerIndex) {
        return this.models == null || this.models.length <= layerIndex || this.models[layerIndex] == null || this.lastReload != EntityModelModifierManager.reloadCounter;
    }

    @Override
    public void markFusionRecomputeModels() {
        if (this.models != null) {
            Arrays.fill(this.models, null);
        }
    }
}

