/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.provider;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.fusion.api.texture.FusionTextureTypeRegistry;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public abstract class FusionTextureMetadataProvider
implements DataProvider {
    private final Map<ResourceLocation, Pair<TextureType<Object>, Object>> metadata = new HashMap<ResourceLocation, Pair<TextureType<Object>, Object>>();
    private final String modName;
    private final PackOutput output;

    public FusionTextureMetadataProvider(String modid, PackOutput output) {
        this.modName = ModList.get().getModContainerById(modid).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(modid);
        this.output = output;
    }

    public final CompletableFuture<?> run(CachedOutput cache) {
        this.generate();
        ArrayList<CompletableFuture> tasks = new ArrayList<CompletableFuture>();
        Path output = this.output.getOutputFolder();
        for (Map.Entry<ResourceLocation, Pair<TextureType<Object>, Object>> entry : this.metadata.entrySet()) {
            ResourceLocation location = entry.getKey();
            Pair<TextureType<Object>, Object> metadata = entry.getValue();
            String extension = location.getPath().endsWith(".mcmeta") ? "" : (location.getPath().lastIndexOf(46) > location.getPath().lastIndexOf(47) ? ".mcmeta" : ".png.mcmeta");
            Path path = Path.of("assets", location.getNamespace(), "textures", location.getPath() + extension);
            JsonObject json = new JsonObject();
            json.add("fusion", (JsonElement)FusionTextureTypeRegistry.serializeTextureData(metadata.left(), metadata.right()));
            tasks.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)output.resolve(path)));
        }
        return CompletableFuture.allOf((CompletableFuture[])tasks.toArray(CompletableFuture[]::new));
    }

    protected abstract void generate();

    public final <T> void addTextureMetadata(ResourceLocation location, TextureType<T> textureType, T data) {
        Pair<TextureType<T>, T> previousValue = this.metadata.put(location, Pair.of(textureType, data));
        if (previousValue != null) {
            throw new RuntimeException("Duplicate texture metadata for '" + String.valueOf(location) + "'!");
        }
    }

    public String getName() {
        return "Fusion Texture Metadata Provider: " + this.modName;
    }
}

