/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.common.collect.Sets;
import com.supermartijn642.fusion.extensions.PackResourcesExtension;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FilePackResources.class})
public class FilePackResourcesMixin
implements PackResourcesExtension {
    @Final
    @Shadow
    private static Logger LOGGER;
    @Unique
    private String overridesFolder;
    @Final
    @Shadow
    private FilePackResources.SharedZipFileAccess zipFileAccess;

    @Override
    public void setFusionOverridesFolder(@NotNull String folder) {
        this.overridesFolder = folder;
    }

    @Shadow
    private String addPrefix(String string) {
        throw new AssertionError();
    }

    @Inject(method={"getResource(Ljava/lang/String;)Lnet/minecraft/server/packs/resources/IoSupplier;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getResource(String path, CallbackInfoReturnable<IoSupplier<InputStream>> ci) {
        ZipEntry zipEntry;
        if (this.overridesFolder == null) {
            return;
        }
        path = this.overridesFolder + (String)path;
        ZipFile zipFile = this.zipFileAccess.getOrCreateZipFile();
        if (zipFile != null && (zipEntry = zipFile.getEntry(this.addPrefix((String)path))) != null) {
            ci.setReturnValue((Object)IoSupplier.create((ZipFile)zipFile, (ZipEntry)zipEntry));
        }
    }

    @Inject(method={"getNamespaces"}, at={@At(value="RETURN")}, cancellable=true)
    private void getNamespaces(PackType type, CallbackInfoReturnable<Set<String>> ci) {
        if (this.overridesFolder == null) {
            return;
        }
        ZipFile zipFile = this.zipFileAccess.getOrCreateZipFile();
        if (zipFile == null) {
            return;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        HashSet namespaces = Sets.newHashSet((Iterable)((Iterable)ci.getReturnValue()));
        String typePath = this.addPrefix(this.overridesFolder + type.getDirectory() + "/");
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String name = zipEntry.getName();
            String namespace = FilePackResources.extractNamespace((String)typePath, (String)name);
            if (namespace.isEmpty()) continue;
            if (ResourceLocation.isValidNamespace((String)namespace)) {
                namespaces.add(namespace);
                continue;
            }
            LOGGER.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)namespace, (Object)this.zipFileAccess.file);
        }
        ci.setReturnValue((Object)namespaces);
    }

    @ModifyVariable(method={"listResources"}, at=@At(value="HEAD"), ordinal=0)
    private PackResources.ResourceOutput modifyListResources(PackResources.ResourceOutput output, PackType type, String namespace, String path) {
        if (this.overridesFolder == null) {
            return output;
        }
        ZipFile zipFile = this.zipFileAccess.getOrCreateZipFile();
        if (zipFile == null) {
            return output;
        }
        HashSet<ResourceLocation> overriddenLocations = new HashSet<ResourceLocation>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        String namespaceDirectory = this.addPrefix(this.overridesFolder + type.getDirectory() + "/" + namespace + "/");
        String pathDirectory = namespaceDirectory + path + "/";
        while (enumeration.hasMoreElements()) {
            String name;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !(name = zipEntry.getName()).startsWith(pathDirectory)) continue;
            String identifier = name.substring(namespaceDirectory.length());
            ResourceLocation location2 = ResourceLocation.tryBuild((String)namespace, (String)identifier);
            if (location2 != null) {
                overriddenLocations.add(location2);
                output.accept((Object)location2, (Object)IoSupplier.create((ZipFile)zipFile, (ZipEntry)zipEntry));
                continue;
            }
            LOGGER.warn("Invalid path in datapack: {}:{}, ignoring", (Object)namespace, (Object)identifier);
        }
        return (location, streamSupplier) -> {
            if (!overriddenLocations.contains(location)) {
                output.accept(location, streamSupplier);
            }
        };
    }
}

