/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.js_furniture_mod.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModernTableBlock
extends Block {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape HORIZONTAL = Shapes.or((VoxelShape)Block.box((double)-12.0, (double)15.0, (double)0.0, (double)28.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)-11.75, (double)0.0, (double)0.25, (double)-10.75, (double)15.0, (double)1.25), Block.box((double)-11.75, (double)0.0, (double)14.75, (double)-10.75, (double)15.0, (double)15.75), Block.box((double)26.75, (double)0.0, (double)14.75, (double)27.75, (double)15.0, (double)15.75), Block.box((double)26.75, (double)0.0, (double)0.25, (double)27.75, (double)15.0, (double)1.25), Block.box((double)26.85, (double)0.4, (double)1.25, (double)27.65, (double)1.2, (double)14.75), Block.box((double)-11.65, (double)0.4, (double)1.25, (double)-10.85, (double)1.2, (double)14.75)});
    private static final VoxelShape VERTICAL = Shapes.or((VoxelShape)Block.box((double)0.0, (double)15.0, (double)-12.0, (double)16.0, (double)16.0, (double)28.0), (VoxelShape[])new VoxelShape[]{Block.box((double)14.75, (double)0.0, (double)-11.75, (double)15.75, (double)15.0, (double)-10.75), Block.box((double)0.25, (double)0.0, (double)-11.75, (double)1.25, (double)15.0, (double)-10.75), Block.box((double)0.25, (double)0.0, (double)26.75, (double)1.25, (double)15.0, (double)27.75), Block.box((double)14.75, (double)0.0, (double)26.75, (double)15.75, (double)15.0, (double)27.75), Block.box((double)1.25, (double)0.4, (double)26.85, (double)14.75, (double)1.2, (double)27.65), Block.box((double)1.25, (double)0.4, (double)-11.65, (double)14.75, (double)1.2, (double)-10.85)});

    public ModernTableBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> HORIZONTAL;
            case Direction.SOUTH -> HORIZONTAL;
            case Direction.EAST -> VERTICAL;
            case Direction.WEST -> VERTICAL;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

