/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.item.predicates;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.modifier.item.ItemPredicate;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.util.IdentifierUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;

public class PotionItemPredicate
implements ItemPredicate {
    public static final Serializer<PotionItemPredicate> SERIALIZER = new Serializer<PotionItemPredicate>(){

        @Override
        public PotionItemPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!(json.has("potion") && json.get("potion").isJsonPrimitive() && json.getAsJsonPrimitive("potion").isString())) {
                throw new JsonParseException("Potion-predicate must have string property 'enchantment'!");
            }
            if (!IdentifierUtil.isValidIdentifier(json.get("potion").getAsString())) {
                throw new JsonParseException("Property 'enchantment' must be a valid identifier, not '" + json.get("potion").getAsString() + "'!");
            }
            ResourceLocation potionIdentifier = new ResourceLocation(json.get("potion").getAsString());
            Potion potion = (Potion)BuiltInRegistries.f_256980_.m_7745_(potionIdentifier);
            if (potion == null || potion == Potions.f_43598_) {
                throw new JsonParseException("Unknown potion '" + potionIdentifier + "'!");
            }
            return new PotionItemPredicate(potion);
        }

        @Override
        public JsonObject serialize(PotionItemPredicate value) {
            JsonObject json = new JsonObject();
            json.addProperty("potion", BuiltInRegistries.f_256980_.m_7981_((Object)value.potion).toString());
            return json;
        }
    };
    private final Potion potion;

    public PotionItemPredicate(Potion potion) {
        if (potion == null) {
            throw new NullPointerException("Potion must not be null!");
        }
        this.potion = potion;
    }

    @Override
    public boolean test(ItemStack stack) {
        return PotionUtils.m_43579_((ItemStack)stack) == this.potion;
    }

    @Override
    public Serializer<? extends ItemPredicate> getSerializer() {
        return SERIALIZER;
    }
}

