/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.resources;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.extensions.PackExtension;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;

public class MinimumVersionWarningScreen
extends Screen {
    private static final ResourceLocation FUSION_LOGO = new ResourceLocation("fusion", "textures/resourcepacks/fusion_icon.png");
    private final PackSelectionModel.EntryBase pack;
    private final Consumer<Boolean> confirmation;
    private final Component title;
    private final int titleWidth;
    private final FormattedCharSequence packName;
    private final MultiLineLabel packDescription;
    private final MultiLineLabel headerMessage;
    private final MultiLineLabel confirmationMessage;
    private final Component currentVersionLabel;
    private final Component requiredVersionLabel;
    private final Component currentVersion;
    private final Component requiredVersion;
    private final int versionLabelTextWidth;
    private final int versionTextWidth;
    private final Button confirmButton;
    private final Button cancelButton;

    public MinimumVersionWarningScreen(PackSelectionModel.EntryBase pack, Consumer<Boolean> confirmation) {
        super((Component)Component.m_237115_((String)"fusion.resource_packs.warning_screen.title"));
        this.pack = pack;
        this.confirmation = confirmation;
        Font font = Minecraft.m_91087_().f_91062_;
        this.title = Component.m_237115_((String)"fusion.resource_packs.warning_screen.title").m_130940_(ChatFormatting.UNDERLINE);
        this.titleWidth = font.m_92852_((FormattedText)this.title);
        int width = font.m_92852_((FormattedText)pack.m_7356_());
        if (width > 157) {
            FormattedText croppedTitle = FormattedText.m_130773_((FormattedText[])new FormattedText[]{font.m_92854_((FormattedText)pack.m_7356_(), 157 - font.m_92895_("...")), FormattedText.m_130775_((String)"...")});
            this.packName = Language.m_128107_().m_5536_(croppedTitle);
        } else {
            this.packName = pack.m_7356_().m_7532_();
        }
        this.packDescription = MultiLineLabel.m_94345_((Font)font, (FormattedText)pack.m_99929_(), (int)157, (int)2);
        this.headerMessage = MultiLineLabel.m_94341_((Font)font, (FormattedText)Component.m_237115_((String)"fusion.resource_packs.warning_screen.message"), (int)220);
        this.confirmationMessage = MultiLineLabel.m_94341_((Font)font, (FormattedText)Component.m_237115_((String)"fusion.resource_packs.warning_screen.confirmation"), (int)220);
        this.currentVersionLabel = Component.m_237115_((String)"fusion.resource_packs.warning_screen.current_version");
        this.requiredVersionLabel = Component.m_237115_((String)"fusion.resource_packs.warning_screen.required_version");
        this.versionLabelTextWidth = Math.max(font.m_92852_((FormattedText)this.currentVersionLabel), font.m_92852_((FormattedText)this.requiredVersionLabel));
        this.currentVersion = Component.m_237113_((String)FusionClient.getFusionVersion()).m_130940_(ChatFormatting.GOLD);
        this.requiredVersion = Component.m_237113_((String)((PackExtension)pack.f_99933_).getFusionMetadata().getMinimumVersion()).m_130940_(ChatFormatting.GOLD);
        this.versionTextWidth = Math.max(font.m_92852_((FormattedText)this.currentVersion), font.m_92852_((FormattedText)this.requiredVersion));
        this.confirmButton = Button.m_253074_((Component)Component.m_237115_((String)"fusion.resource_packs.warning_screen.confirm"), b -> confirmation.accept(true)).m_252780_(80).m_253136_();
        this.cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"fusion.resource_packs.warning_screen.cancel"), b -> confirmation.accept(false)).m_252780_(80).m_253136_();
    }

    public Component m_142562_() {
        return Component.m_237115_((String)"fusion.resource_packs.warning_screen.message").m_7220_((Component)Component.m_237115_((String)"fusion.resource_packs.warning_screen.confirmation"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.confirmButton.m_264152_(this.f_96543_ / 2 - this.confirmButton.m_5711_() - 2, this.f_96544_ / 2 + 110 - this.confirmButton.m_93694_());
        this.cancelButton.m_264152_(this.f_96543_ / 2 + 2, this.f_96544_ / 2 + 110 - this.cancelButton.m_93694_());
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.m_142416_((GuiEventListener)this.cancelButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f - 110.0f, 0.0f);
        int titleLeft = -(this.titleWidth + 17) / 2;
        RenderSystem.enableBlend();
        graphics.m_280163_(FUSION_LOGO, titleLeft, 0, 0.0f, 0.0f, 12, 12, 12, 12);
        RenderSystem.disableBlend();
        graphics.m_280430_(this.f_96547_, this.title, titleLeft + 17, 2, -1);
        poseStack.m_85849_();
        poseStack.m_85836_();
        int middleHeight = 98 + this.headerMessage.m_5770_() * 10 + this.confirmationMessage.m_5770_() * 10;
        poseStack.m_252880_((float)this.f_96543_ / 2.0f, (float)(this.f_96544_ - middleHeight) / 2.0f, 0.0f);
        graphics.m_280509_(-98, 0, 98, 36, FastColor.ARGB32.m_13660_((int)70, (int)255, (int)255, (int)255));
        graphics.m_280163_(this.pack.m_6876_(), -96, 2, 0.0f, 0.0f, 32, 32, 32, 32);
        graphics.m_280648_(this.f_96547_, this.packName, -62, 3, 0xFFFFFF);
        this.packDescription.m_6508_(graphics, -62, 14, 10, -8355712);
        graphics.m_280656_(-115, 115, 44, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        int textLeft = -Math.max(this.headerMessage.m_214161_(), this.confirmationMessage.m_214161_()) / 2;
        this.headerMessage.m_6508_(graphics, textLeft, 54, 10, -1);
        int textHeight = this.headerMessage.m_5770_() * 10;
        this.confirmationMessage.m_6508_(graphics, textLeft, 58 + textHeight, 10, -1);
        graphics.m_280656_(-115, 115, 66 + (textHeight += this.confirmationMessage.m_5770_() * 10), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        textLeft = -(this.versionLabelTextWidth + 5 + this.versionTextWidth) / 2;
        graphics.m_280430_(this.f_96547_, this.currentVersionLabel, textLeft, 76 + textHeight, FastColor.ARGB32.m_13660_((int)255, (int)180, (int)180, (int)180));
        graphics.m_280430_(this.f_96547_, this.requiredVersionLabel, textLeft, 88 + textHeight, FastColor.ARGB32.m_13660_((int)255, (int)180, (int)180, (int)180));
        graphics.m_280430_(this.f_96547_, this.currentVersion, textLeft + this.versionLabelTextWidth + 5, 76 + textHeight, 0xFFFFFF);
        graphics.m_280430_(this.f_96547_, this.requiredVersion, textLeft + this.versionLabelTextWidth + 5, 88 + textHeight, 0xFFFFFF);
        poseStack.m_85849_();
    }

    public boolean m_6913_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.confirmation.accept(false);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

