/*
 * Decompiled with CFR 0.152.
 */
package fr.lynzel.fdn.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.lynzel.fdn.config.ClientConfig;
import fr.lynzel.fdn.util.ColorUtils;
import fr.lynzel.fdn.util.GUIUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3x2fStack;

public class DamageParticle
extends Particle {
    public static final List<DamageParticle> DAMAGE_PARTICLES = new ArrayList<DamageParticle>();
    private final Minecraft MC = Minecraft.getInstance();
    private final Font FONT;
    private final int animationDuration;
    private final float animationMinSize;
    private final float animationMaxSize;
    private final float animationMinBrightness;
    private final float animationMaxBrightness;
    private final float animationMinOpacity;
    private final float animationMaxOpacity;
    private final float animationMinSpeed;
    private final float animationMaxSpeed;
    private String text;
    private int color;
    private boolean isVisible;

    public DamageParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.FONT = this.MC.font;
        this.animationDuration = (Integer)ClientConfig.ANIM_DURATION.get();
        this.animationMinSize = ((Double)ClientConfig.ANIM_MIN_SIZE.get()).floatValue();
        this.animationMaxSize = ((Double)ClientConfig.ANIM_MAX_SIZE.get()).floatValue();
        this.animationMinBrightness = ((Double)ClientConfig.ANIM_MIN_BRIGHTNESS.get()).floatValue();
        this.animationMaxBrightness = ((Double)ClientConfig.ANIM_MAX_BRIGHTNESS.get()).floatValue();
        this.animationMinOpacity = ((Double)ClientConfig.ANIM_MIN_OPACITY.get()).floatValue();
        this.animationMaxOpacity = ((Double)ClientConfig.ANIM_MAX_OPACITY.get()).floatValue();
        this.animationMinSpeed = ((Double)ClientConfig.ANIM_MIN_SPEED.get()).floatValue();
        this.animationMaxSpeed = ((Double)ClientConfig.ANIM_MAX_SPEED.get()).floatValue();
        DAMAGE_PARTICLES.add(this);
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void remove() {
        super.remove();
        DAMAGE_PARTICLES.remove((Object)this);
    }

    public void tick() {
        if (++this.age >= this.animationDuration) {
            this.remove();
            return;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.xd = 0.0;
        this.yd = 0.1 * (double)this.calculateSpeed();
        this.zd = 0.0;
        this.move(this.xd, this.yd, this.zd);
        Vec3 cameraPosition = this.MC.gameRenderer.getMainCamera().getPosition();
        Vec3 particlePosition = new Vec3(this.x, this.y, this.z);
        double distance = particlePosition.distanceTo(cameraPosition);
        if (distance > 32.0) {
            this.isVisible = false;
            return;
        }
        BlockHitResult raycast = this.level.clip(new ClipContext(cameraPosition, particlePosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.MC.player));
        this.isVisible = raycast.getType() == HitResult.Type.MISS;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
    }

    public void customRender(GuiGraphics guiGraphics, float partialTicks) {
        double worldPositionZ;
        if (!this.isVisible) {
            return;
        }
        Vec3 cameraPosition = this.MC.gameRenderer.getMainCamera().getPosition();
        double worldPositionX = this.x;
        double worldPositionY = Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y);
        Vec3 worldPosition = new Vec3(worldPositionX, worldPositionY, worldPositionZ = this.z);
        Vec2 screenPosition = GUIUtils.worldPositionToScreenPosition(worldPosition);
        if (screenPosition == null) {
            return;
        }
        float size = this.calculateSize(partialTicks);
        float brightness = this.calculateBrightness(partialTicks);
        float opacity = this.calculateOpacity(partialTicks);
        int rgb = ColorUtils.darkenColor(this.color, 1.0f - brightness);
        int argb = (int)(opacity * 255.0f) << 24 | rgb & 0xFFFFFF;
        float distance = (float)worldPosition.distanceTo(cameraPosition);
        float distanceScale = 6.0f / distance;
        float textXOffset = (float)(-this.FONT.width(this.text)) / 2.0f;
        Objects.requireNonNull(this.FONT);
        float textYOffset = (float)(-9) / 2.0f;
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        poseStack.translate(screenPosition.x, screenPosition.y);
        poseStack.scale(distanceScale, distanceScale);
        poseStack.scale(size, size);
        guiGraphics.drawString(this.FONT, this.text, (int)textXOffset, (int)textYOffset + 1, ColorUtils.darkenColorWithAlpha(argb, 0.45f), false);
        guiGraphics.drawString(this.FONT, this.text, (int)textXOffset, (int)textYOffset, argb, false);
        poseStack.popMatrix();
    }

    private float calculateSize(float partialTicks) {
        float f1 = 8.0f * ((float)this.age + partialTicks) / (float)this.animationDuration * (this.animationMaxSize - this.animationMinSize);
        float f2 = -4.0f * ((float)this.age + partialTicks) / (float)this.animationDuration * (this.animationMaxSize - this.animationMinSize) + 4.0f * this.animationMaxSize - 4.0f * this.animationMinSize;
        float f3 = -(f1 + Math.abs(f1)) + 2.0f * this.animationMaxSize - 2.0f * this.animationMinSize;
        float f4 = -(f2 + Math.abs(f2)) + 2.0f * this.animationMaxSize - 2.0f * this.animationMinSize;
        return -(f3 + Math.abs(f3) + f4 + Math.abs(f4)) / 4.0f + this.animationMaxSize;
    }

    private float calculateBrightness(float partialTicks) {
        float f1 = 8.0f * ((float)this.age + partialTicks) / (float)this.animationDuration * (this.animationMaxBrightness - this.animationMinBrightness) - this.animationMaxBrightness + this.animationMinBrightness;
        float f2 = -4.0f * ((float)this.age + partialTicks) / (float)this.animationDuration * (this.animationMaxBrightness - this.animationMinBrightness) + 4.0f * this.animationMaxBrightness - 4.0f * this.animationMinBrightness;
        float f3 = -(f1 + Math.abs(f1)) + 2.0f * this.animationMaxBrightness - 2.0f * this.animationMinBrightness;
        float f4 = -(f2 + Math.abs(f2)) + 2.0f * this.animationMaxBrightness - 2.0f * this.animationMinBrightness;
        return -(f3 + Math.abs(f3) + f4 + Math.abs(f4)) / 4.0f + this.animationMaxBrightness;
    }

    private float calculateOpacity(float partialTicks) {
        float f1 = 8.0f * ((float)this.age + partialTicks) / (float)this.animationDuration * (this.animationMaxOpacity - this.animationMinOpacity);
        float f2 = -8.0f * ((float)this.age + partialTicks) / (float)this.animationDuration * (this.animationMaxOpacity - this.animationMinOpacity) + 8.0f * this.animationMaxOpacity - 8.0f * this.animationMinOpacity;
        float f3 = -(f1 + Math.abs(f1)) + 2.0f * this.animationMaxOpacity - 2.0f * this.animationMinOpacity;
        float f4 = -(f2 + Math.abs(f2)) + 2.0f * this.animationMaxOpacity - 2.0f * this.animationMinOpacity;
        return -(f3 + Math.abs(f3) + f4 + Math.abs(f4)) / 4.0f + this.animationMaxOpacity;
    }

    private float calculateSpeed() {
        float f1 = 4.0f * (float)this.age / (float)this.animationDuration * (this.animationMinSpeed - this.animationMaxSpeed) + this.animationMaxSpeed - this.animationMinSpeed;
        float f2 = 4.0f * (float)this.age / (float)this.animationDuration * (this.animationMaxSpeed - this.animationMinSpeed) + 3.0f * this.animationMinSpeed - 3.0f * this.animationMaxSpeed;
        float f3 = -(f1 + Math.abs(f1)) + 2.0f * this.animationMaxSpeed - 2.0f * this.animationMinSpeed;
        float f4 = -(f2 + Math.abs(f2)) + 2.0f * this.animationMaxSpeed - 2.0f * this.animationMinSpeed;
        return -(f3 + Math.abs(f3) + f4 + Math.abs(f4)) / 4.0f + 2.0f * this.animationMaxSpeed - this.animationMinSpeed;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }
}

